function writeSLMLmodel( model, fileID )
% WRITESLMLMODEL Helper function that handles the writing of the SLML model
% to a file

% Author: Ivan E. Cao-Berg (icaoberg@cmu.edu)
% Created: May 8, 2007
% Last Update: August 27, 2010
%
% Copyright (C) 2010 Department of Computational Biology
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

%list of cells
fprintf( fileID, '\t%s\n', '<listOfCells>' );
fprintf( fileID, '\t\t%s\n', '<cell>' );

%list of models
fprintf( fileID, '\t\t\t%s\n', '<listOfModels>' );
format free;
fprintf( fileID, '\t\t\t\t%s\n', ['<model id="' num2str(now) '">'] );
format;

%list of compartments
fprintf( fileID, '\t\t\t\t\t%s\n', '<listOfCompartments>' );

%helper functions
nuclearModel2slml( model.nuclearShapeModel, [], fileID );
%cellShapeModel2slml( model.cellShapeModel, fileID );
%proteinModel2slml( model.proteinModel, compartmentName, proteinName, fileID );

%close lists/components
fprintf( fileID, '\t\t\t\t\t%s\n', '</listOfCompartments>' );
fprintf( fileID, '\t\t\t\t%s\n', '</model>' );
fprintf( fileID, '\t\t\t%s\n', '</listOfModels>' );
fprintf( fileID, '\t\t%s\n', '</cell>' );
fprintf( fileID, '\t%s\n', '</listOfCells>' );
end%writeSLMLmodel
