function writeParameter( file, name, value, tab, constant, complex, ...
    type, structure )
% WRITEPARAMETER Helper function that facilitates writing parameter tags from
% SLML Level 1 Version 1

% Author: Ivan E. Cao-Berg (icaoberg@cmu.edu)
% Last Update: February 15, 2008
%
% Copyright (C) 2008  Murphy Lab
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu/software or
% send email to murphy@cmu.edu

[fileID tabs] = checkInputArguments( file, tab );
if( nargin == 7 )
    write( fileID, 'parameter', value, tabs, 'name', name, 'constant', ...
        constant, 'complex', complex, 'type', type );
elseif( nargin == 8 )
    write( fileID, 'parameter', value, tabs, 'name', name, 'constant', ...
        constant, 'complex', complex, 'type', type, 'structure', structure );
else
    error('CellOrganizer: Wrong number of input arguments');
end
end%parameter

%--------------------------------------------------------------------------
function [fileID tabs] = checkInputArguments( file, tab )

%check tab
tabs = '';
if( isempty(tab) )
    return;
elseif( ischar(tab) )
    tabs = tab;
elseif( ceil(tab) < 0 )
    error('CellOrganizer: Input argument tab must be nonnegative');
elseif( tab == 0  )
    tabs = '';
else
    for( i=1:1:tab )
        tabs = [ tabs '\t' ];
    end
end

%check file
if( strcmpi( file, '' ) )
    %if file == '' assume print to screen
    fileID = '';
elseif( isnumeric( file ) )
    %assume file is a number, thus it may be a Matlab file ID
    if( isempty(fopen( file )) )
        error( 'Argument file is not a valid Matlab file ID' );
    else
        fileID = file;
    end
elseif( ischar( file ) )
    %assume file is a string, thus it may be a filename
    fileID = fopen( file, 'w' );
else
    error('Argument file not a valid fileID or filename');
end
end%checkInputArguments