function fnames = tz_get3dfeatnames
%TZ_GET3DFEATNAMES Get 3D SLF names.
%   FNAMES = TZ_GET3DFEATNAMES returns a cell array of the 3D SLF names.

%   22-Jul-2005 Initial write TINGZ Initial write T. Zhao
%   Copyright (c) Murphy Lab, Carnegie Mellon University

fnames = {'No. of objects in the image',...
        'Euler number of the image',...
        'Average object volume (average number of above threshold voxels per object)', ... 
        'Std.Dev of object volumes',...
        'Ratio of Max(object volumes) to Min(object volumes)',...
        'Average Obj to protein COF distance',...
        'Std.Dev of Obj to protein COF distances',...
        'Ratio of Max to Min obj distance from prot COF',...
        'Horizontal projection of average Obj to protein COF distance',...
        'Horizontal projection of Std.Dev of Obj to protein COF distances',...
        'Horizontal projection of ratio of Max to Min obj distance from prot COF',...
        'Vertical projection of average Obj to protein COF distance',...
        'Vertical projection of Std.Dev of Obj to protein COF distances',...
        'Vertical projection of ratio of Max to Min obj distance from prot COF',...
        'The fraction of above threshold pixels that are along an edge',...
        'The fraction of fluorescence in above threshold pixels that are along an edge',...
        'Average of angular second moment',...
        'Average of contrast',...
        'Average of correlation',...
        'Average of sum of squares of variance',...
        'Average of inverse difference moment',...
        'Average of sum average',...
        'Average of sum variance',...
        'Average of sum entropy',...
        'Average of entropy',...
        'Average of difference variance',...
        'Average of difference entropy',...
        'Average of info measure of correlation 1',...
        'Average of info measure of correlation 2',...
        'Range of angular second moment',...
        'Range of contrast',...
        'Range of correlation',...
        'Range of sum of squares of variance',...
        'Range of inverse difference moment',...
        'Range of sum average',...
        'Range of sum variance',...
        'Range of sum entropy',...
        'Range of entropy',...
        'Range of difference variance',...
        'Range of difference entropy',...
        'Range of info measure of correlation 1',...
        'Range of info measure of correlation 2'};
fnames=fnames';