function [theta,center]=tz_bwmajorangle(img)
%TZ_BWMAJORANGLE Obsolete. See ML_BWMAJORANGLE.
%   THETA = TZ_BWMAJORANGLE(IMG) returns the angle of the major axis of
%   the binary version of the 2D image IMG. This means that the major
%   angle is calculated on the binary image in which a pixel is one if and
%   only if the corresponding pixel in IMG has value greater than 0. This
%   function also considers skewness of the image. The unit of the THETA
%   is radian.
%   
%   [THETA,CENTER] = TZ_BWMAJORANGLE(...) also returns the center of the
%   binary image.
%   
%   See also

%   17-Sep-2005 Initial T. Zhao
%   ??-???-???? Initial TINGZ T. Zhao
%   30-OCT-2004 Modified T. Zhao
%       - add comments
%   23-Mar-2004 Modified T. Zhao
%       - Debugged 
%   Copyright (c) Murphy Lab, Carnegie Mellon University

error(tz_genmsg('of','tz_bwmajorangle','ml_bwmajorangle'));

if nargin < 1
    error('Exactly 1 argument is required')
end

img=img>0;

mom = tz_bwmoment(img);

center=[mom.cx,mom.cy];

theta = .5 * atan((mom.mu02 - mom.mu20)/2/mom.mu11)+sign(mom.mu11)*pi/4;%+pi/2;

ntheta=[cos(theta),sin(theta)];
[x,y]=find(img>0);
imgskew=skewness([x,y]*ntheta');
if imgskew<0
    theta=theta+pi;
end

% img=imrotate(img, -theta*180./pi, 'bilinear', 'loose');
% 
% mom = tz_bwmoment(img);
% dmass=sum(sum(img(1:round(mom.cx-1),:),2)>0);
% umass=sum(sum(img(round(mom.cx+1):end,:),2)>0);
% 
% if umass<dmass
%     theta=theta+pi;
% end

