function answer = isCompatible()
%ISCOMPATIBLE True iff the system is compatible with the CellOrganizer,
%false otherwise.
%
% See also HASTOOLBOX

% Ivan E. Cao-Berg
%
% Copyright (C) 2008-2015 Murphy Lab
% Carnegie Mellon University
%
% March 11, 2014 I. Cao-Berg Updated method to use native isunix, ismac and
% ispc methods
% February 2, 2014 I. Cao-Berg Changed method to return true if the
% computer is a PC but issue a warning
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

if( nargin ~= 0 )
    error('CellOrganizer: Wrong number of input arguments');
else
    if ( ismac || isunix  || ispc )
        toolboxes = { 'Image Processing Toolbox', ...
                'Statistics Toolbox', ...
                'Curve Fitting Toolbox' };
            
            for index=1:1:length( toolboxes )
                toolbox = toolboxes{index};
                if ~hasToolbox( toolbox )
                    warning( [ 'Unable to find toolbox: ' ...
                        toolbox '.'] );
                    answer = false;
                    return
                end
                answer = true;
            end
            
            if ispc()
                warning( ['CellOrganizer has not been tested in any ' ...
                    'Windows flavor. Some functionality might not be ' ...
                    ' working.'] );
            end
    else
        warning('Unsupported operating system.');
        answer = false;
    end
end
end%isCompatible
