function clean_synthesis_temp_files()
%CLEAN_SYNTHESIS_TEMP_FILES Helper function that removes temporary files
%related to synthesis. These files should always be removed before
%synthesis since there might be overlap between the current job and
%previous jobs.

% Copyright (C) 2014 Murphy Lab
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

directory = pwd;
delete([directory filesep 'temp' filesep 'image*.mat']);

directory = [ directory filesep 'temp' filesep 'microtubules' ];
if exist( directory )
    rmdir( directory, 's' );
end