function framework = createSBMLFrameworkstruct(images,param)
%CREATESBMLFRAMEWORKSTRUCT This function returns a framework structure for saving as SBML-Spatial
%
%Inputs:
%images = cell array containing the nucleus and cell images generated by
%cellorganizer
%
%Outputs:
%framework = a struct for framework objects with triangulated mesh type
%encoding
%instance2SBML.m to generate a SBML-Spatial instance.
%

%Author: Devin Sullivan September 16, 2013
%Edited:
%D. Sullivan 9/18/13 - Cleaned up code and added support for multiple
%models
%D. Sullivan 9/19/13 - Reworked struct to work with single instance2SBML
%file
%
% Copyright (C) 2013 Murphy Lab
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu


if length(images)>2
    warning(['Expecting cell and nuclear frameworks.',...
        'Name set to number order for remaining images']);
end

if nargin<2
    param.SBML_CName = {'cell'};
    param.SBML_NName = {'nuc'};
end

if ~isfield(param,'SBML_CName')
param.SBML_CName = {'cell'};
end

if ~isfield(param,'SBML_NName')
    param.SBML_NName = {'nuc'};
end

framework = struct;
framework.name = 'frameworkMesh';

framework.list = struct;
for i = 1:length(images)
    framework.list(i).type = 'triangle mesh';
    if i==1
        framework.list(i).name = param.SBML_NName{1};
        framework.list.ordinal = 2;
    elseif i==2
        framework.list(i).name = param.SBML_CName{1};
        framework.list(i).ordinal = 1;
    else
        framework.list(i).name = ['unknown',num2str(i)];
    end
    %D. Sullivan 11/4/14 - adjusting resolution to ensure cubic voxels
%     currimg = AdjustResolutions(images{i},param.resolution.objects,param.resolution.cubic);
    framework.list(i).img = images{i};
%     framework.list(i).img = currimg;
end

end