function protfit_percell(dna_image_file,cell_image_file,...
    prot_image_file,mask_image_file,param,currfile)
%Trains protein patterns per cell and saves temporary files 

%Author: Devin Sullivan 6/7/13-6/13/13 - adapted from Tao Peng's 
%                                        train_protein_model2.m
%
%
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu/ or
% send email to murphy@cmu.edu


disp( ['Finding objects in image ',num2str(currfile)] ); tic;
[param] = findobjs_run_percell(prot_image_file,...
    mask_image_file,...
    param.objtemppath,param,currfile);
toc
disp( 'Fitting Gaussian mixtures to the objects...' );
learngaussobjs_run3(param.savefitdir, param,currfile);

param = gmm_objempdistr_percell(param.savefitdir,...
    param.objstatsdir,param,currfile);
%             model.size = gmm_objsizefit(objstatdir);
comp_percell_size = 1;
if comp_percell_size==1
    model.size = gmm_objsizefit_percell(param.objstatsdir,...
        param.objsizedir,currfile);
end

tic;
%D. Sullivan 2/22/13 added param input to objpos_run to pass the
%resolution of the prot image
% model.position.beta = objpos_run(imgdir,savedir);
beta = objpos_run_percell( param.objposdir, param, currfile );
toc

