function param = gmm_objempdistr_percell(gaussobjpath,savepath,param,currfile)
% Combining single object property for statistical analysis including
% object size, number, and intensities
%
%

%Author: 
%
%Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% Feb 22, 2013 D. Sullivan   Removed the fixed scaling of z by 5. 
% Feb 24, 2013 D. Sullivan   Added param struct to pass in the upsampling
%                            of the z dimension of the protein pattern.
%                            param.proteinUpsampleZ. Returns updated model
%                            resolution in param structure
%
% June 13, 2013 D. Sullivan  Refactored code to compute model parameters in
%                            a per-cell manner for parallel computing.

%protype = {'LAM','Nuc','Mit','TfR'};
% files = ml_dir([gaussobjpath filesep '*gaussobjs.mat']);

%for each pattern in the protype list
% for pidx = 1:1:length(files)
  if ~exist([savepath filesep 'gaussobjs_' num2str(currfile) '.mat'], 'file' )

    %load the matfile that contains the gaussian objects
    load([gaussobjpath filesep 'gaussobjs_' num2str(currfile)]);

    % Intensity fit and number fit
    intensities = [];
    objsize = [];

%     for i = 1:length(mixes)
        objnum = 0;
        for j = 1:length(mixes{1})
            %if ~isempty(mixes{i}(j))
               %if ~isempty(mixes{i}(j).ncentres)
                for k = 1:mixes{1}(j).ncentres
                    %disp( [ '(i,j,k)=(' num2str(i) ',' num2str(j) ',' num2str(k) ')']);
                    intensities = [intensities;...
                        objintens{1}(j)*mixes{1}(j).priors(k)];
                    sigma = mixes{1}(j).covars(:,:,k);
                    
                    %Z dimension - resize z to make cubic voxels. This is
                    %necessary 
                    if isfield(param.model,'proteinUpsampleZ')
                        sigma(:,end) = sigma(:,end) * param.model.proteinUpsampleZ;
                        sigma(end,:) = sigma(end,:) * param.model.proteinUpsampleZ;

                    end
                    
                    lambda = sqrt(eig(sigma));
                    objsize = [objsize;fliplr(lambda')];
                   %catch
                    %disp( ['Ignoring object ' num2str(k) '.' ] );
                   %end
                end
               %end
               %end                
%                 try
                 objnum = objnum + mixes{1}(j).ncentres;
%                 catch
                 
%                 end
            end
%         end    
    
     if ~exist( savepath, 'dir' )
       mkdir( savepath );
     end
      save([savepath filesep 'gaussobjs_' num2str(currfile) '.mat'],...
          'objsize','intensities','objnum')
 else  
disp( 'Intermediate results found, skipping recalculation' );
 end
% end

%D. Sullivan 2/24/13 Adjust the protein_resolution given the upsamplings
% %X dimension
% if isfield(param,'proteinUpsampleX')
%     param.model.protein_resolution(1) = param.model.protein_resolution(1)*param.proteinUpsampleX;
% end
% %Y dimension
% if isfield(param,'proteinUpsampleY')
%     param.model.protein_resolution(2) = param.model.protein_resolution(2)*param.proteinUpsampleY;
% end
if isfield(param.model,'proteinUpsampleZ')
    param.model.protein_resolution(3) = param.model.protein_resolution(3)/param.model.proteinUpsampleZ;
end
