function [param] = findobjs_run_percell(prot_image_file,...
    mask_image_file,savepath,param,currfile)
% Extract objects from 3D HeLa images

% Author: Devin Sullivan - adapted from Tao Peng's findobjs_run.m
%
% Copyright (C) 2011-2013 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
%
%Changes from findobjs_run.m:
% June 15, 2012 G. Johnson Changed ml_findobjs loop to accept images of
%         arbritrary x and y dimension
% July 18, 2012 I. Cao-Berg Updated method to ignore single pixel objects
% August 1, 2012 I. Cao-Berg Fixed a bug in the code that would insert an artifact to the 
%                            end of the image that would later be considered by the 
%                            algorithm as an object
% August 2, 2012 D. Sullivan Added masking of protein image using segcell.
%                            this ensures you find no objects outside of
%                            the segmented cell
% Feb 22, 2013 D. Sullivan   Added protein resolution adjustment so that
%                            gaussians are trained on cubic voxels with the
%                            maximum resolution
% Feb 24, 2013 D. Sullivan   Removed Feb 22 change for speed
% May 15, 2013 I. Cao-Berg Updated method to support wildcards
%%%
%%
% June 7-13 2013 D. Sullivan changed to per-cell type computations. Major
%                            changes include passing a single file
%                            path rather than file path and adding a
%                            'currfile' parameter to track what loop
%                            iteration we are currently on in parallel.
%                            Also passing in a tempdirectory
%                            structure as part of param.
%%
%Changes since refactoring:
% Sept 3 2013 D. Sullivan    slight bug fix on check if verbose for
%                            displaying intermediate message to the user.
%
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

if ~exist(savepath,'dir')
    mkdir(savepath)
end

%icaoberg 15/5/2013
output_directory = [savepath filesep 'preprocessed'];
if ~exist( output_directory, 'dir' )
    mkdir( output_directory );
end

%icaoberg 15/5/2013
% dna_image_files = ml_ls( dnaImagesDirectoryPath );
% cell_image_files = ml_ls( cellImagesDirectoryPath );
% prot_image_files = ml_ls( protImagesDirectoryPath );
% try
%     masks_image_files = ml_ls( param.masks );
% catch
%     mask_image_files = '';
% end

param = ml_initparam(param, struct('smoothxy', 10, 'smoothz', 3));

H = fspecial3('Gaussian',[param.smoothxy,param.smoothxy,param.smoothz]);

% for i = 1:length(prot_image_files)
%     disp(['Image:' num2str(i)])
%     %icaoberg 15/5/2013
%     try
%         dna_image_file = dna_image_files{i};
%     catch
%         dna_image_file = '';
%     end
%     
%     cell_image_file = cell_image_files{i};
%     prot_image_file = prot_image_files{i};
%     
    if ~isempty(mask_image_file)
%         mask_image_file = masks_image_files{i};
        crop = ml_readimage(mask_image_file,'tif');
    else
%         mask_image_file = [];
        crop = [];
    end
    
    if ~exist( [savepath filesep 'obj' num2str(currfile) '.mat'], 'file' )
%      try
        prot = ml_readimage( prot_image_file );
        stacknum = size(prot,3);
        prot = double(prot);
        

        
        %D. Sullivan 6/4/13 get rid of this due to new file formats (bioformats) 
%         croplist = ml_ls( mask_image_file );
%         crop = [];
%         for k = 1:length(croplist)
%             crop(:,:,k) = ml_readimage(croplist{k}) > 0;
%         end
%         crop = any(crop,3);
      if ~exist( [output_directory filesep 'cell' num2str(currfile) '.mat'], 'file' )
        disp( 'Preprocessing image' )
        %devins 8/2/12
        %Need to make sure we are not finding objects outside of the cell
        segdataFolder = [ param.preprocessingFolder filesep ...
            'cell' num2str(currfile) '.mat' ];

        %this file should contain variables 'segcell', 'segdna', 'downsample'
        load(segdataFolder);
        %need to make the image it's original size
        %create a blank image
        cellmask = zeros(original_segcellsize);
        %put segcell into the blank image

        cellmask(:,:,bot_slice:top_slice) = segcell;
        %figure out what size to make the final image
        finalsize = size(prot);
        %resize x and y
        resizedcell= imresize(cellmask,finalsize(1:2));
        %shouldn't need to resize the z since it does not change in
        %preprocessing, but just in case...
        %make sure the z dimension is the correct size 
        resizedcell = tp_stretch3d(resizedcell,finalsize(3));
        
        %create the masked protein image
        prot = prot.*logical(resizedcell);
        
        %end of 8/2/12 addition
        %%%
        
        procimage = ml_preprocess(double(prot),crop,'ml','yesbgsub','nih');
        %procimage(1:12,:,:) = [];
        %procimage(end-11:end,:,:) = [];
        %procimage(:,1:12,:) = [];
        %procimage(:,end-11:end,:) = [];
        
        dimobjimg = imfilter(procimage,H,'same');
        centers =  ml_imlocalmax(dimobjimg);
        
        save([output_directory filesep 'cell' num2str(currfile) '.mat'], ...
               'procimage', 'prot', 'crop', 'resizedcell', ...
               'dna_image_file', 'cell_image_file', 'prot_image_file', ...
               'mask_image_file','centers' );
      else
        if param.verbose
            %9/3/13 D. Sullivan minor bug fix.
            %if verbose
              disp(['preprocessed protein image found for cell ',...
                  num2str(currfile),'. loading results.'])
        end
        load([output_directory filesep 'cell' num2str(currfile) '.mat']);
      end

        %icaoberg 22/4/2014
        %reused blocks
        blockSize = size(prot,1);
        %blockSize = 100;
        numBlocksX = round(size(procimage,1) / blockSize);
        numBlocksY = round(size(procimage,2) / blockSize);
        
        objects = cell(numBlocksX, numBlocksY);
        %D. Sullivan - may be able to parallelize this block in the future 
        for r = 1:numBlocksX
            for c = 1:numBlocksY
                disp( ['Finding objects in block {' num2str(r) ',' num2str(c) '}' ] );
                if r == numBlocksX
                    %icaoberg 1/8/2012
                    rEnd = size(procimage,1)-1;
                else
                    rEnd = r*blockSize;
                end
                if c == numBlocksY
                    %icaoberg 1/8/2012
                    cEnd = size(procimage,2)-1;
                else
                    cEnd = c*blockSize;
                end
              
                %icaoberg 17/7/2012
                blockimage = procimage((r-1)*blockSize+1:rEnd,(c-1)*blockSize+1:cEnd,:);
                objs = ml_findobjs(blockimage);
                objSizes = cellfun('size',objs,1);
                objs = objs(objSizes>1);
                objects{r,c} = objs;
            end
        end
        
        save([savepath filesep 'obj' num2str(currfile)],'objects','centers', 'blockSize', 'numBlocksX', 'numBlocksY')
%      catch
%         disp(['Unable to process image ' prot_image_file ]);
%      end
    else
        disp( 'Intermediate files found, skipping locating objects' );
    end
