function [ nuc, cell, improt, img ] = intermed2img(varargin )
%G. Johnson Dec 1, 2013
%
%Displays per-cell parameterizations from the intermediate results
%directory
%
%Work in progress

nuc = [];
cell = [];
improt = [];
img = [];

%icaoberg 12/2/2013
%just in case to fails to read intermediate results file
if nargin == 2
    intermed_dir = varargin{1};
    rendernum = varargin{2};

    try
        load([intermed_dir filesep 'cell_' num2str(rendernum) '.mat'])
    catch
        warning( ['Unable to load temporary file: cell_' ...
            num2str(rendernum) '.mat']);
        return
    end
else
    cell_param = varargin{1};
    rendernum = nan;
end
    
    


%icaoberg 12/2/2013
%just in case we lack some of the parameters
try
    coefs = cell_param.nucleus.features.spfeat.coefs;
    
    u = (coefs(:,1) + coefs(:,end))/2;
    coefs(:,1) = u;
    coefs(:,end) = [];
    
    model = struct;
    model.dimensionality = '3D';
    model.type = 'framework';
    
    model.nuclearShapeModel = struct;
    model.nuclearShapeModel.type = 'medial axis';
    model.nuclearShapeModel.height.stat.mu = cell_param.nucleus.features.spfeat.height;
    model.nuclearShapeModel.height.stat.sigma = 0;
    model.nuclearShapeModel.surface.stat.mu = coefs(:)';
    model.nuclearShapeModel.surface.stat.sigma = 0;
    model.nuclearShapeModel.resolution = [1,1,1];
    
    model.nuclearShapeModel.surface.number = cell_param.nucleus.features.spfeat.number;
    model.nuclearShapeModel.surface.form = cell_param.nucleus.features.spfeat.form;
    model.nuclearShapeModel.surface.order = cell_param.nucleus.features.spfeat.order;
    model.nuclearShapeModel.surface.constknot_phi = [0.2500 0.3750 0.5000 0.6250 0.7500];
    model.nuclearShapeModel.surface.constknot_h = 0.5000;
    
    model.cellShapeModel = struct;
    model.cellShapeModel.type = 'ratio';
    model.cellShapeModel.meanShape.const = cell_param.rad_ratio;
    model.cellShapeModel.modeShape.const = 0;
    
    param.generatemeanshape = true;
    param.synthesis = 'framework';
    
    [nuc, cell] = model2framework(model, param);
catch
    warning( ['Unable to synthesize framework for cell_' ...
        num2str(rendernum) '.mat']);
    return
end

nuc = flipdim(flipdim(permute(nuc, [2,1,3]), 1),2);
cell = flipdim(flipdim(permute(cell, [2,1,3]), 1),2);


%icaoberg 12/2/2013
%just in case we cannot synthesize protein instances
try
    if isfield(cell_param, 'protein')
        centers = vertcat(cell_param.protein.gaussian_objects.mixes{:}.centres);
        covars = cat(3,cell_param.protein.gaussian_objects.mixes{:}.covars);
        objinten = [cell_param.protein.gaussian_objects.mixes{:}.priors];
        
        imsize = size(cell_param.compartments.stats.indexedimg);
        
        improt = gauss2img(centers, covars, objinten, imsize);
    else
        improt = [];
    end
catch
    warning( 'Unable synthesize protein pattern image' );
    improt = [];
end

% icaoberg 12/2/2013
% i was unable to find a file containing the compartments field. where is
% this setup?
% img = cell_param.compartments.stats.indexedimg;
% img(img == 3) = 1;
end



