function [embed_final, locs_final, eig, param] = showShapeSpaceFigure(model, labels, param)

%need to add:
%   traces - grj 11/15/14
%   scaling option
if ~exist('param', 'var')
    param = [];
end

nimgs = model.cellShapeModel.numimgs;

param = ml_initparam(param, struct( ...
        'skipmissing', true, ...
        'rebuild_pos', false, ...
        'plot_dims', [1,2], ...
        'cm', @jet, ...
        'traces', [], ...
        'embedfctn', @cmdscale, ...
        'subsize', 400, ...
        'synthorder', 1:nimgs ...
        ));

cellnums = 1:nimgs;

if ~exist('labels', 'var') || isempty(labels)
    labels = 1:nimgs;
end

skipmissing = param.skipmissing;
cm = param.cm;
plot_dims = param.plot_dims;
rebuild_pos = param.rebuild_pos;


cellimg = [];
c = 1;
while isempty(cellimg)
    cellimg = model.cellShapeModel.imfunc(c);
    c = c+1;
end
imsize = size(cellimg);

ndims = 2;    

if rebuild_pos
    if skipmissing
        %remove rows fully populated with nans
        d = model.cellShapeModel.distances_incomplete;
        d_nan = d;
        d_nan(logical(eye(size(d)))) = nan;

        rminds = all(isnan(d_nan),1);
        d(rminds,:) = [];
        d(:,rminds) = [];

        keepinds = find(~rminds);

        labels = labels(keepinds);
        cellnums = cellnums(keepinds);

        %remove any other entries with nans
        rminds = any(isnan(triu(d)),1);
        d(rminds,:) = [];
        d(:,rminds) = [];

        keepinds = ~rminds;

        labels = labels(keepinds);
        cellnums = cellnums(keepinds);

    else
        d = model.cellShapeModel.distances;
    end
    [embed_pos, eig] = param.embedfctn(d);
else
    eig = [];
    keepinds = ~any(isnan(model.cellShapeModel.positions),2);
    labels = labels(keepinds);
    cellnums = cellnums(keepinds);
    embed_pos = model.cellShapeModel.positions(keepinds,:);
end

[ulabels, ~, labelinds ] = unique(labels);

labels = zeros(size(keepinds));
labels(keepinds) = labelinds;

if strcmpi(class(cm), 'function_handle')
    colors = cm(length(ulabels))*0.8;
else
    colors = cm;
end

%i dont know why this is here grj 11/24/14
% if length(ulabels) == length(labels)
%     colors = colors(randperm(length(labels)),:);
% end


proj = embed_pos(:,plot_dims);

locs = proj;


% if exist('traces', 'var')
%     traces = traces(all(ismember(traces, keepinds),2),:);
% 
%     tracemap = ones(max(keepinds), 1) * -1;
%     tracemap(keepinds) = 1:length(keepinds);
% 
% 
%     shapeInserter = vision.ShapeInserter('Shape','Lines','BorderColor','Custom', 'CustomBorderColor', uint8([125 125 125]));
% 
%    lines = int32([locs(tracemap(traces(:,1)),2:-1:1) locs(tracemap(traces(:,2)),2:-1:1)]);
% 
%    lines = lines + int32(repmat(imsize./4, [size(traces,1) 2]));
% %         line = int32([x(i),y(i),x(j), y(j)]);
%     img = step(shapeInserter, img, lines);
% end

set(gcf, 'color', 'w')
hold on


param = ml_initparam(param, struct( ...
            'imfunc', @(x) img2flat(model.cellShapeModel.imfunc(x), colors(labels(x),:)) ...
            ));


synthorder = param.synthorder(ismember(param.synthorder, cellnums));        
        
for imnum = 1:length(synthorder)
    
    cellind = synthorder(imnum);
    
    imnum
    try
        cellimg = param.imfunc(cellind);
        
        if isempty(cellimg) %|| any(cellimg(:) .* cellbounds(:))
            continue;
        end

        %center the image on the point where it belongs
        place_image(cellimg, locs(cellind,:), param);

        hold on
    catch
        disp('adsf')
    end
end

axis equal
axis tight

embed_final = nan(nimgs, size(embed_pos,2));
embed_final(cellnums,:) = embed_pos;

locs_final = nan(nimgs, 2);
locs_final(cellnums,:) = locs;

param.cellnums = cellnums;

end


    