function [img] = diffeo_img_function(filenum, compressed_imgs, maxsize, imsizes, imcrops)

    if ~isempty(compressed_imgs{filenum})
        img = CompressLib.decompress(compressed_imgs{filenum});
        
        img = padarray(img, [imcrops(filenum,1)-1, imcrops(filenum,3)-1], 'pre');
        img = padarray(img, [imsizes(filenum,1) - imcrops(filenum,2), imsizes(filenum,2) - imcrops(filenum,4)], 'post');

    else
        img = [];
    end
    
    if ~isempty(img)
        imsize = size(img);
        imsize = [imsize, ones(1,3 - length(imsize))];

        pad = (maxsize - imsize) ./ 2;

        img = padarray(img, floor(pad), 0, 'both');

        img = padarray(img, double(~(floor(pad) == pad)), 0, 'pre');
        img = double(img);
    end
end