function cellfit_percell(dna_image_file,cell_image_file, ...
                    prot_image_file,mask_image_file,...
                    param,currfile)
%Trains per-cell cell shape model

%First check if they exist already
cellcodefile = [param.celltemppath filesep...
    'cellcodes_' num2str(currfile) '.mat'];
if ~exist(cellcodefile)
    find_cell_codes( dna_image_file, ...
        cell_image_file, ...
        prot_image_file, ...
        mask_image_file,...
        param.celltemppath, param,currfile );    

    % add the cell-nuc ratios for each cell, could combine these
    % two files in the future
    
    
    if exist(cellcodefile, 'file') %this gets set in find_cell_codes... this should be made better grj 7/9/13
        [rad_ratio,cellnucratios,nucbottomslices] =...
            extract_radius_ratio(cellcodefile);
    end
elseif param.verbose
        disp(['Found cell shape model for cell ',num2str(currfile),...
            '. Skipping']);

end