% test01m
%
% This method demonstrates the use of the holefinding functionality to
% find the "nuclear hole" in a protein pattern without a nuclear stain.

% Created: Gregory R. Johnson 7/2/13
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

clear


protpath = 'pc12_48hr_mitored.tif';
maskpath = 'pc12_48hr_mitored_cellboundary.tif';

downsample = 0.5;

improt = imresize(double(tif2img(protpath)), downsample, 'bilinear');
immask = imresize(tif2img(maskpath), downsample, 'nearest');

dnamask = findDnaMask(improt, immask);

figure, img2vol(ml_imgbgsub(improt,'common'));
figure, img2vol(dnamask);