classdef TestModel2Img < matlab.unittest.TestCase
    properties
    end
    
    methods ( Test) 
        function test_empty_model_list( testCase )
            disp('Must return empty list when list of models is empty')
            models = {};
            param = [];
            testCase.verifyEqual( model2img(models, param), []);
        end
        
        function test_model_list_not_cell_array( testCase )
            disp('Must return empty list of images if list of models is not a cell array')
            models = [];
            param = [];
            testCase.verifyEqual( model2img(models, param), []);
        end
        
        function test_param_structure_empty( testCase )
            disp('test0003: Should continue with default values if the param structure is empty')
            load('../../../models/2D/endosome.mat')
            models = {model};
            param = [];
            imgs = model2img(models, param);
            testCase.verifyGreaterThan(fsize(imgs,1), 0)
            rmdir( [ pwd filesep 'temp' ], 's' );
        end
        
        function test_not_empty_param_and_models_list( testCase )
            addpath('../../')
            files={'../../../models/2D/nucleolus.mat', ...
                '../../../models/2D/endosome.mat', ...
                '../../../models/2D/mitochondrion.mat', ...
                '../../../models/2D/lysosome.mat'};
            param=struct;
            for j = 1: 1 : length(files)
                load(files{j});
                models{j}=model;
            end
            model2img(models,param)
            testCase.verifyTrue(check({'temp/image.mat'}))
            rmdir( 'temp', 's' );
        end
    end
end

            