disp('test003: Should not continue if model does not contrain nuclearShapeModel');
load('../../../models/2D/endosome.mat');

disp( 'Removing nuclear shape model from structure' );
model = rmfield(model, 'nuclearShapeModel');
param.synthesis = 'framework';
[nucimgs, cellimgs, outres] = model2framework(model, param);
assert(isempty(nucimgs));
assert(isempty(cellimgs));
assert(isempty(outres));

temp = [ pwd filesep 'temp' ];
if exist( temp )
    rmdir( [ pwd filesep 'temp' ], 's' );
end

disp('test003: Should not continue if model does not contrain cellShapeModel');
load('../../../models/2D/endosome.mat');
disp( 'Removing cell shape model from structure' );
model = rmfield(model, 'cellShapeModel');
param.synthesis = 'framework';
[nucimgs, cellimgs, outres] = model2framework(model, param);
assert(isempty(nucimgs));
assert(isempty(cellimgs));
assert(isempty(outres));

temp = [ pwd filesep 'temp' ];
if exist( temp )
    rmdir( [ pwd filesep 'temp' ], 's' );
end