function answer = run_all_tests( option )

% Ivan E. Cao-Berg
%
% Copyright (C) 2013 Murphy Lab
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

if nargin == 0
    disp( 'Method called without input arguments. Running test using default value: simple' );
    option = 'simple';
end

if ~(isa( option, 'char')  || ...
        strcmpi( option, 'simple' ) || ...
        strcmpi( option, 'extended' ))
    disp( 'Incorrect option value. Setting to default value: simple' );
    option = 'simple';
end

%assumes cellorganizer is at the parent level
cellorganizer = '../';
directory = pwd;

cd( cellorganizer );
setup;
cd( directory );

addpath( directory );

answer = false;
switch lower( option )
    case 'simple'
        disp('Run all utilities tests');
        cd('utilities');
        cd('img2tif');
        run_all_img2tif;
        cd('..');
%         cd('tif2img');
%         run_all_tif2img;
%         cd('..');
%         cd('ml_readimage');
%         run_all_ml_readimage;
        %cd(['..' filesep 'ml_preprocess']);
        %run_all_ml_preprocess;
        %cd(['..' filesep 'ml_preprocess2D']);
        %run_all_ml_preprocess2D;
        cd(['..' filesep]);
        
        disp('Run all synthesis tests');
        cd('synthesis');
        disp('model2framework');
        cd('model2framework');
        run_all_model2framework;
        cd('..');
        cd('model2img');
        run_all_model2img;
        cd('..');
        cd('model2instance');
        run_all_model2instance;
        cd('..');
        cd('slml2img');
        run_simple_slml2img;
        cd(['..' filesep '..']);
        
        disp('Run all training tests');
        cd(['training' filesep 'img2slml']);
        run_all_img2slml;
        cd(['..' filesep 'img2model']);
        run_simple_img2model;
        cd(['..' filesep '..']);
    case 'extended'
        disp('Run test for findDnaMask');
        cd(['utilities' filesep 'findDnaMask']);
        run_all_findDnaMask;
        cd('..');
        
        disp('Run test for report')
        cd('slml2report');
        run_all_slml2report;
        cd(['..' filesep '..']);
        disp('Run all synthesis tests');
        cd('synthesis');
        cd('slml2img');
        run_extented_slml2img
        cd(['..' filesep '..'])
        disp('Run all training tests');
        %cd(['training' filesep 'img2model']);
        %run_extended_img2model;
    otherwise
        disp( 'Something is not right. Check script.' )
end

answer = true;
end

function answer=check(files)

answer=true;

for file = files
    found=dir(file{1});
    if length(found)==0
        answer=false;
    end
end
end