function [ seg_region ] = seg_hela( impath, maskpath )
%SEG_HELA Summary of this function goes here
%   Detailed explanation goes here

img = ml_readimage(impath);
mask = ml_readimage(maskpath);
mask = mask(:,:,1);

mask = repmat(mask, [1,1, size(img,3)]) > 0;


img = mat2gray(img);

img_region = img > graythresh(img);

img_region = img_region.*mask;

regions = bwconncomp(img_region);
[~, ind] = max(cellfun(@(x) size(x,1), regions.PixelIdxList));

seg_region = false(size(img));

seg_region(regions.PixelIdxList{ind}) = true;


seg_region = imfill(seg_region, 'holes');

end

