
cd(scriptpath(1:inds(end)));

if ~exist('celllineIdx', 'var') || isempty(celllineIdx)
   % which cell line(s) we will use, 0 - Hela, 1 - HPA:A-431, 2 - HPA:U-2OS, 3 - HPA:U-251MG, 4 - HPA:RT-4, 5 - HPA:PC-3, 6 - HPA:Hep-G2, 7 - HPA:HeLa, 8 - HPA:CaCo2, 9 - HPA:A-549, 10 - HPA:Hek-293, 11 - HPA:MCF-7 
   celllineIdx = 0:11;
end

if ~exist('imgpath','var')
   imgpath = [ pwd filesep 'images' ];  % use the default image path(es) in images/
end

%clear all
%close all

addpath(genpath([pwd '/GLCM_Features1/']));
addpath(genpath( './lib/SLIC/' ));
addpath([pwd filesep 'HPA2D/slicfiles/']);

for Idx = celllineIdx(:)'

    if Idx == 0
        % 3D HeLa, generate microtubules and estimate model parameters using directly 3D HeLa cells
        cd HeLa3D
        disp( 'Preprocessing 3D HeLa images')
        tic
        %grj 10/31/14 downsample images to be 1:1:1 aspect
        %ratio pixels
        raw2proc_hela_script  % preprocess images 
        toc

        disp( 'Segmenting images')
        tic
        auto_segment_hela_script  % segment images into cells
        toc

        disp( 'Preprocess cells to get cell geometries' )
        tic
        process_seg_hela_script  % preprocess cells to get cell geometries (cell shapes and nuclear shapes)
        toc

        disp('Estimate single microtubule intenstity')
        tic
        scriptx_new  % estimate single microtubule intensity
        toc

        disp( 'Generating microtubule distributions')
        tic
        allscriptsave = './allscriptsave.mat';
        if ~exist(allscriptsave, 'file')
            all_script_script  % generate microtubule distributions
            save(allscriptsave);
        else
            load(allscriptsave)
        end

        toc

        disp( 'Extract features for generated synthetic cells')
        tic
        extractfeaturessave = './extractfeaturessave.mat';
        if ~exist(extractfeaturessave, 'file')
            extract_features_script  % extract features for generated synthetic cells
            save(extractfeaturessave)
        else
            load(extractfeaturessave)
        end
        toc

        disp( 'Extract features for real cells')
        tic
        getallcellsfeatvec  % extract features for real cells
        toc

        disp( 'Estimate model parameters indirectly')
        tic
        recover_parameters_from_real_image_ownlib_script  % estimate model parameters indirectly
        toc
        cd ..


        % 2D HeLa
        %generate microtubules and estimate model parameters using approximated 3D cell geometries generated from 2D HeLa central slices
        addpath('./HPA2D/slicfiles/');
        cd HeLa2D, 
        scriptx_new
        script_loadimage  % preprocess 2D central slices to get 3D cell geometries (cell shapes and nuclear shapes)
        all_script_script
        extract_features_script
        getallcellsfeatvec
        recover_parameters_from_real_image_ownlib_script
        compare2d3d  % compare the results of model parameters from using directly 3D HeLa cells or 2D central slices
        cd ..

    end  % end if


    if Idx>=1 && Idx<=3
        % 2D HPA
        addpath(genpath('./lib/HPA_lib/SLICfeatures/matlab'));
        addpath(genpath('./lib/HPA_lib/segmentation'));
        addpath(genpath('./lib/HPA_lib/CalcFeatures'));
        addpath('./lib/HPA_lib/system');
        cd HPA2D, generate microtubules and estimate model parameters using approximated 3D cell geometries generated from 2D HPA images (3 cell lines)
        script_segmentation(imgpath)  % segment image fields into single cells
        scriptx_new % extrapolate 3D PSF
        script_loadimage_script_script(Idx,imgpath) % generate the data
        script_getmean_mtint % estimate single mt intensity
        all_script_script(Idx)  % generate synthetic images
        extract_features_script(Idx)  % feature calculation
        wrap_features_script(Idx)  % wrap the calculated individual features together
        getallcellsfeatvec_hpa  % calculate features for all real images
        recover_parameters_from_real_image_ownlib_script_script(Idx)

        if Idx==3
            all_script_script_syn  % generate synthetic images
            extract_features_script_syn  % feature calculation
            wrap_features_script_syn  
            recover_parameters_from_real_image_ownlib_script_script_syn
        end

    cd ..

    end  % end if


    if Idx>=4 && Idx<=11
        % 2D AddCelllines, generated microtubules and estimate model parameters using approximated 3D cell geometries generated from 2D HPA images (more 8 cell lines)
        addpath(genpath('./HPA2D/slicfiles'));
        addpath(genpath('./lib/HPA_lib/SLICfeatures/matlab'));
        addpath(genpath('./lib/HPA_lib/segmentation'));
        cd ./AddCelllines
        wrap_allimages(Idx)  % wrap information of all images of additional cell lines
        scriptx_new % extrapolate 3D PSF
        script_getmean_mtint % estimate single mt intensity 
        getallcellsfeatvec_hpa

        script_loadimage_script_script(Idx,imgpath)
        all_script_script(Idx)  % generate synthetic images
        extract_features_script(Idx)  % feature calculation
        wrap_features_script(Idx)  
        recover_parameters_from_real_image_ownlib_script_script(Idx)
        cd ..

    end  % end if

end  % end for Idx = celllineIdx(:)'


if sum(abs(unique(celllineIdx) - [0:11])) == 0
%% regenerate results of tables and figures in the paper

regenResults

end  % end if

