function demo3DSBML( param )
%This demo converts a sample SBML file to an SBML-spatial instance using
%the "matchSBML" function. This function takes an SBML file, matches the
%compartments in the file with available models and synthesizes the
%appropriate instances 

% Author: Devin Sullivan - 4/9/14
% Copyright (C) 2014-2015 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3DSBML.m');
% curr_path = curr_path(1:end-10);
% cd(curr_path);
%D. Sullivan 7/24/13 changed to fileparts to allow more flexibility
[folder,name,ext] = fileparts(curr_path);
cd(folder);

try
 state = rng(3);
catch
 state = RandStream.create('mt19937ar','seed',3);
 RandStream.setDefaultStream(state);
end

outputDirectory = pwd;
param.targetDirectory = outputDirectory;
param.prefix = 'synthesizedImages';
param.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'disc';
param.verbose = true;
param.debug = true;
param.output.tifimages = true;

param = ml_initparam( param, ...
    struct( 'numberOfSynthesizedImages', 1 ) );
param = ml_initparam( param, ...
    struct( 'numberOfGaussianObjects', 500 ) );
param = ml_initparam( param, ...
    struct( 'verbose', true ) );

param.rendAtStd = 1;
param.objstd = 1.1;
param.overlapsubsize = 1;

param.output.SBML = 'Motivating_example_cBNGL2_13_sbml.xml';%true;
% param.output.SBML = 1;

%note, the framework will be synthesized using the first protein model
%found to match the given patterns in the SBML file. 
%Changing the order/priority of this is not supported at this time.
modelsdir = '../../../models/3D/';
[modelpaths,param] = matchSBML(param.output.SBML,modelsdir,param);
%modelpaths = {[modelsdir,'tfr.mat']};
slml2img(modelpaths,param);
% slml2img( {'../../../models/3D/lamp2.mat','../../../models/3D/tfr.mat'}, param );

