% demo3DMultiresSynth
%
% Synthesize multiple 3D images from a lysosome model,
% at different resolutions

% Created: Ivan E. Cao-Berg as demo3D09
% Modified by Gregory R. Johnson on 9/24/13
%
% Copyright (C) 2012-2103 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% July 21, 2012 R.F. Murphy Additional documentation.
% August 10, 2012 I. Cao-Berg Reflected changes from img2projection
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3DMultiresSynth.m');
curr_path = curr_path(1:end-21);
cd(curr_path);
clear param

  


outputDirectory = pwd;
param = [];
param.targetDirectory = outputDirectory;

param.numberOfSynthesizedImages = 1;
param.image.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'disc';
param.verbose = true;
param.overlapthresh = 0; %to make the synthesis go very fast

state = rng(3); %reset the rng
param.prefix = 'imres1';
param.outputres = 1;

if ~exist( './imres1/cell1/cell.tif', 'file' )
    slml2img( {'../../../models/3D/lamp2.mat', ...
        }, param );
else
    disp('Image exists on disk. Skipping synthesis.');
end

state = rng(3); %reset the rng
param.prefix = 'imres2';
param.outputres = 0.25;

if ~exist( './imres2/cell1/cell.tif', 'file' )
    slml2img( {'../../../models/3D/lamp2.mat', ...
        }, param );
else
    disp('Image exists on disk. Skipping synthesis.');
end


state = rng(3); %reset the rng
param.prefix = 'imres3';
param.outputres = 2;

if ~exist( './imres3/cell1/cell.tif', 'file' )
    slml2img( {'../../../models/3D/lamp2.mat', ...
        }, param );
else
    disp('Image exists on disk. Skipping synthesis.');
end

