% demo3DDynamic
%
% Synthesizes 10 image using a diffeomorphic model 
% for the nuclear and cell shape performing a random walk through shape
% space
% Results will be three TIFF files, one each for cell boundary, 
% nuclear boundary, and protein, in folder "synthesizedImages/cell1"

% Created: Devin Sullivan 6/25/13
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

MovementModelTime = tic 
%D. Sullivan 6/25/13 added fileparts command to remove hard coded
%dependence on how long file name was 
curr_path = which('demo3DDynamic.m');
% curr_path = curr_path(1:end-10);
[folder,name,ext] = fileparts(curr_path);
cd(folder);
clear param

try
 state = rng(3);
catch
 state = RandStream.create('mt19937ar','seed',3);
 RandStream.setDefaultStream(state);
end

diary( 'demo3D15Dynamicdiary.txt' );
outputDirectory = pwd;
param = [];
param.targetDirectory = outputDirectory;
param.prefix = 'synthesizedImages';
param.numberOfSynthesizedImages = 1;
param.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'disc';
param.verbose = true;
param.debug = true;
param.synthesis.synthesis = 'framework';
param.synthesis.diffeomorphic.maximum_iterations = 40;
param.randomwalk = true;

%D. Sullivan 7/16/13 added these previously hardcoded things as params
param.framefolder = './frames/';
param.walksteps = 3;
param.walk_type = 'brownian';
%param.walk_type = 'willmore';
% param.walk_type = 'density';

%D. Sullivan 7/22/13 temporary directory added 
% param.tempdir = './temp';
% 
% if exists('./frames/walk.tmp')
% elseif exists('./frames/walk.mat')
% end

slml2img( {'../../../models/3D/hela_model.mat'}, param );
toc(MovementModelTime)
diary off
