function demo3DDiffeomorphicWindowSize()
%This demo exists to illustrate how padding size and window size effect the
%performance of diffeomorphic metric. Currently incomplete GRJ 4/16/14
%
%todo: output results
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

funcname = mfilename();

curr_path = which(funcname);
curr_path = curr_path(1:end-(length(funcname) + 2));
cd(curr_path);

 frameworkflag = 0;

%icaoberg 27/7/2012
if nargin == 0 | nargin == 1
 if strcmpi( lower(frameworkflag), 'yes' )
    frameworkflag = true;
 else
    frameworkflag = false;
 end
end

if ~isa( frameworkflag, 'logical' )
   warning( 'Input variable framework flag must be boolean. Exiting demo.' );
   return
end


% Generate some superellipses:
 generate_options = struct();
 % Set this:
 generate_options.number_images = 3;
 generate_options.minimum_relative_semidiameter = 1 / 4;
 generate_options.maximum_relative_semidiameter = 2 / 3;
 generate_options.generate_cycle = true;
 % Set this:
 generate_options.image_width = 128;

 [shapes, shape_parameters] = generate_superellipse_shape_set(generate_options);

% nucleus.id                (optional) Holds the id of the nuclear model. Default is empty.
param.nucleus.type = 'diffeomorphic';
param.cell.type = 'diffeomorphic';
param.protein.type = 'vesicle';

param.verbose = true;
param.debug = true;

% train.flag                (optional) Selects what model is going to be trained ('nuclear',
%                           'framework', or 'all'). Default is 'all'
param.train.flag = 'framework';
param.model.resolution = [1,1,1];
param.model.downsampling = [1,1,1];
param.model.filename = mfilename;

param.tempparent = [curr_path filesep 'temp' filesep];


%documentation
param.documentation.description = 'This model has been trained using demo3D20 from CellOrganizer';


for i = 1:length(shapes)
    objimg{i} = @() shapes{i} > 0;
end

imfunc = @(x) double(shapes{x} > 0);

windowradii = 128./[1,2,4,8,16];

for i = 1:length(windowradii)
    filename = ['diffeomorphic_wr' num2str(windowradii(i))];
    
    param.model.filename = filename;
    param.model.diffeomorphic.window_radius = windowradii(i);
    param.model.diffeomorphic.image_function = imfunc;

       
    param.model.diffeomorphic.tempdir = [param.tempparent filesep filename];
    tic
    success = img2slml( '3D', objimg, objimg, [], param );
    timer(i) = toc;
end