% function [ output_args ] = demo3DDiffeoSynth( input_args )
%This demo illustrates how to sample uniformly at random from a
%diffeomorphic model

scriptname = mfilename;

scriptpath = which(scriptname);
tokens = regexp(scriptpath, filesep);

cd(scriptpath(1:tokens(end)));

param.targetDirectory = scriptname;



load('helamodel.mat')

cellinds = find(all(~isnan(model.cellShapeModel.positions),2));

positions = model.cellShapeModel.positions(cellinds,:);

minpos = min(positions,[],1);
maxpos = max(positions,[],1);


numimgs = 5;
for i = 1:numimgs %this may take a few seconds, and of course will take long the greater the dimensionality of the space
    %sample from the uniform distribution ANDed to the convex hull of the triangulation
    simplex_idx = nan;
    
    while isnan(simplex_idx)
        point = rand([1, size(minpos,2)]).* (maxpos - minpos) + minpos;
        simplex_idx = tsearchn(model.cellShapeModel.positions,model.cellShapeModel.tessellation,point);
    end
    
    points(i,:) = point;
    
    param.position = point;
        savedir = [scriptpath '_img' num2str(i)];
    if ~exist(savedir, 'dir')
        mkdir(savedir)
    end
    cd(savedir);
    
    param.targetDirectory = [scriptname filesep 'img' num2str(i)];
    
    imgs{i} = model2img({model}, param);
end
