function [ output_args ] = demo3DDiffeoSynth( input_args )
%This demo illustrates different ways to sample from points in a
%diffeomorphic model.

funcname = mfilename();

curr_path = which(funcname);
curr_path = curr_path(1:end-(length(funcname) + 2));
cd(curr_path);

 frameworkflag = 0;

%icaoberg 27/7/2012
if nargin == 0 | nargin == 1
 if strcmpi( lower(frameworkflag), 'yes' )
    frameworkflag = true;
 else
    frameworkflag = false;
 end
end

if ~isa( frameworkflag, 'logical' )
   warning( 'Input variable framework flag must be boolean. Exiting demo.' );
   return
end


% Generate some superellipses:
 generate_options = struct();
 % Set this:
 generate_options.number_images = 3;
 generate_options.minimum_relative_semidiameter = 1 / 4;
 generate_options.maximum_relative_semidiameter = 2 / 3;
 generate_options.generate_cycle = true;
 % Set this:
 generate_options.image_width = 128;

 [shapes, shape_parameters] = generate_superellipse_shape_set(generate_options);

% nucleus.id                (optional) Holds the id of the nuclear model. Default is empty.
param.nucleus.type = 'diffeomorphic';
param.cell.type = 'diffeomorphic';
param.protein.type = 'vesicle';

param.verbose = true;
param.debug = true;

% train.flag                (optional) Selects what model is going to be trained ('nuclear',
%                           'framework', or 'all'). Default is 'all'
param.train.flag = 'framework';
param.model.resolution = [1,1,1];
param.model.downsampling = [1,1,1];
param.model.filename = 'demo3DDiffeomorphic';

param.tempparent = [curr_path filesep 'temp' filesep];


%documentation
param.documentation.description = 'This model has been trained using demo3D20 from CellOrganizer';


for i = 1:length(shapes)
    objimg{i} = @() shapes{i} > 0;
end

imfunc = @(x) double(shapes{x} > 0);

windowradii = 128./[1,2,4,8,16];

for i = 1:length(windowradii)
    filename = ['diffeomorphic_wr' num2str(windowradii(i))];
    
    param.model.filename = filename;
    param.model.diffeomorphic.window_radius = windowradii(i);
    param.model.diffeomorphic.image_function = imfunc;

       
    param.model.diffeomorphic.tempdir = [param.tempparent filesep filename];
    tic
    success = img2slml( '3D', objimg, objimg, [], param );
    timer(i) = toc;
end

end

