function answer = demo3D22()
%demo3D22
%
% Synthesizes a protein pattern instance for each of the synthetic images
% from demo3DDiffeoSynth

% Created: Ivan E. Cao-Berg
%
% Copyright (C) 2014 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3D22.m');
[filepath,filename,extension]=fileparts(curr_path);
cd(filepath);
clear filepath

pattern = '../demo3DDiffeoSynth/demo3DDiffeoSynth_grid_pick.m_img*';
copyfile( pattern );
pattern = './demo3DDiffeoSynth_grid_pick.m_img*';
folders = dir( pattern );
for index=1:1:length(folders)
    folder=folders(index).name;
    disp( folder );
    helper_function( folder );
end
end

function answer = helper_function( folder )

outputDirectory = pwd;
param = [];
param.targetDirectory = folder;
param.prefix = 'synthesizedImages';
param.numberOfSynthesizedImages = 1;
param.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'disc';
param.verbose = true;
param.debug = true;
param.synthesis = 'all';

%make sure objects don't overlap.
param.rendAtStd = 1;
param.objstd = 1.1;
param.overlapsubsize = 1;
param.output.tifimages = 1;
%output the SBML-spatial files
param.output.SBML = 1;

param.resolution.cell = [0.3920,0.3920,0.4000];
load( [ folder filesep 'temp' filesep 'image1.mat' ] );
param.instance.nucleus = img;
clear img

load( [ folder filesep 'temp' filesep 'image2.mat' ] );
param.instance.cell = img;
clear img

%trim image
img2d = squeeze(sum(param.instance.cell,3));
xrange = find(sum(img2d,1)>0);
yrange = find(sum(img2d,2)>0);
zrange = find(sum(sum(param.instance.cell,1),2));

param.instance.cell = param.instance.cell(min(yrange):max(yrange), ...
    min(xrange):max(xrange),min(zrange):max(zrange));
param.instance.nucleus = param.instance.nucleus(min(yrange):max(yrange), ...
    min(xrange):max(xrange),min(zrange):max(zrange));

answer = slml2img( {'../../../models/3D/tfr.mat'}, param );
copyfile('./temp/*', [folder filesep 'temp'] );
end
