%demo3D19
%
% This method shows the use of slml2report for creating comparisons between
% parameters of CellOrganzier models.

% Created: Gregory Johnson
%
% Copyright (C) 2013 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu
    
curr_path = which('demo3D19.m');
curr_path = curr_path(1:end-10);
cd(curr_path);

directory = '../../../models/3D/';
instances = { [ directory 'lamp2.mat'], ...
	[ directory 'mit.mat'], [ directory 'tfr.mat'], [ directory 'nuc.mat' ] };


%icaoberg march 14, 2014
%demo no longer requires 
disp('Generating report using only protein parameters');
param = ml_initparam([],struct('includenuclear',false,'includecell',false,'includeprot',true));
slml2report(instances,param)

disp('Testing again with specified independent variable');
indvar = [1:4];
label = 'Model num';
slml2report(instances,param,label,indvar)

disp( 'Generating report for all parameters' );
param = ml_initparam([],struct('includenuclear',true,'includecell',true,'includeprot',true));
slml2report(instances,param)
