% demo3D15
%
% Synthesizes 1 image using a transferrin model for the protein and a diffeomorphic model 
% for the nuclear and cell shape
% Results will be three TIFF files, one each for cell boundary, 
% nuclear boundary, and protein, in folder "synthesizedImages/cell1"

% Created: Ivan E. Cao-Berg
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3D15.m');
curr_path = curr_path(1:end-10);
cd(curr_path);
clear param

try
 state = rng(3);
catch
 state = RandStream.create('mt19937ar','seed',3);
 RandStream.setDefaultStream(state);
end

outputDirectory = pwd;
param = [];
param.targetDirectory = outputDirectory;
param.prefix = 'synthesizedImages';
param.numberOfSynthesizedImages = 1;
param.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'disc';
param.verbose = true;
param.debug = true;
param.synthesis = 'framework';
param.synthesis.diffeomorphic.maximum_iterations = 40;

slml2img( {'./diffeomorphic.mat'}, param );
