function answer = demo3D02()
% demo3D02
%
% Take results from demo3D00 in 
% folder "../demo3D00/synthesizedImages/cell1"
% and generate surface plot

% Created: Robert F. Murphy
%
% Copyright (C) 2012-2013 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% August 10, 2012 I. Cao-Berg Reflected changes from img2plot
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu
    
answer = false;
curr_path = which('demo3D02.m');
curr_path = curr_path(1:end-10);
cd(curr_path);

colors = {'blue', 'green' 'red'};
viewangles = [20,-30];
alphaval = 0.1;

tiffDirectory = '../demo3D00/synthesizedImages/cell1';

%icaoberg 12/5/2013
try
    syn2surfaceplot( tiffDirectory, colors, viewangles, alphaval );
    answer = true;
catch
    warning( 'Unable to make surface plot' );
    answer = false;
end
