function demo2D03( option )
% demo2D03
%
% Trains a 2D generative model of protein location using the 2D HeLa dataset provided
% by the Murphy Lab at http://murphylab.web.cmu.edu/data/ while making
% pretty plots

% Author: Ivan E. Cao-Berg (icaoberg@scs.cmu.edu)
%
% Copyright (C) 2015 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo2D03.m');
curr_path = curr_path(1:end-10);
cd(curr_path);

clc;

if nargin == 0
    fprintf(1,'%s\n', 'demo2D03 - Train a 2D generative model' );
    fprintf(1,'%s\n%s\n%s\n%s\n%s\n', 'Select a dataset to download','(1) LAMP2', '(2) Mit', '(3) Nuc', '(4) TfR' );
    option = input('? ');
end

switch option
    case 1
        pattern = 'lam';
        directory = [ pwd filesep 'LAM' ];
    case 2
        pattern = 'mit';
        directory = [ pwd filesep 'Mit' ];
    case 3
        pattern = 'nuc';
        directory = [ pwd filesep 'Nuc' ];
    case 4
        pattern = 'tfr';
        directory = [ pwd filesep 'TfR' ];
    otherwise
        warning( 'CellOrganizer: Unknown option.' );
        return
end

tarball = [ 'hela2d-' pattern '.tgz' ];
url = 'http://murphylab.web.cmu.edu/data/Hela/2D/';

if ~exist( [ pwd filesep tarball ] )
    disp('Downloading dataset');
    urlwrite( [ url tarball] , tarball );
    disp('Extracting files');
    untar( [ pwd filesep tarball ] );
else
    disp('Pattern found on disk. Extracting files from existing tarball');
    disp('Extracting files');
    system(['tar -xvf ./' tarball] );
end

dna = [ directory filesep 'orgdna' filesep '*.tif' ];
cellm = [ directory filesep 'orgcell' filesep '*.tif' ];
protein = [ directory filesep 'orgprot' filesep '*.tif' ];

%main difference between this demo and demo2D03
param.masks = [ directory filesep 'crop' filesep '*.tif' ];

param.model.filename = [ 'lamp2.xml' ];
param.model.resolution = [ 0.49, 0.49 ];

param.model.name = 'demo2D03';
param.model.id = 'demo2D03';

param.debug = true;
param.verbose = true;
param.display = true;
param.train.flag = 'all';

%documentation
param.documentation.description = 'This model has been trained using demo2D03 from CellOrganizer';
img2slml( '2D', dna, cellm, protein, param );

