%demo2D02
%
% Synthesize one 2D image from the LAMP2 model trained in demo2D01

% Copyright (C) 2013-2015 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo2D02.m');
curr_path = curr_path(1:end-10);
cd(curr_path);

try
 state = rng(12345);
catch err
 state = rand( 'seed', 12345 ); %#ok<RAND>
end

outputDirectory = [ pwd filesep 'images' ];
if ~exist( outputDirectory, 'dir' )
  mkdir( outputDirectory );
end

param = [];
param.targetDirectory = outputDirectory;
param.prefix = 'demo2D02_';
param.numberOfSynthesizedImages = 1;
param.compression = 'lzw';
param.debug = false;
param.verbose = true;
param.display = false;

filename = [ pwd filesep 'lamp2.mat' ];
if ~exist( filename )
    error( [ 'File ' filename ' not found. Please run demo2D01 first.' ] )
else
    slml2img( {filename}, param );
end

