/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCache {
    private static Logger log = LoggerFactory.getLogger(FileCache.class);
    private static List<CacheElement> cache;
    private static final Object lock;
    private static int maxElements;
    private static int minElements;
    private static boolean disabled;
    private static Timer timer;

    public static void init() {
        FileCache.init(10, 20, 1200L);
    }

    public static void init(int minElementsInMemory, int maxElementsInMemory, long period) {
        minElements = minElementsInMemory;
        maxElements = maxElementsInMemory;
        cache = new ArrayList<CacheElement>(2 * maxElements - minElements);
        disabled = false;
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer();
        timer.schedule((TimerTask)new CleanupTask(), 1000L * period, 1000L * period);
    }

    public static void disable() {
        disabled = true;
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
        if (cache != null && cache.size() > 0) {
            FileCache.clearCache(false);
        }
    }

    public static void exit() {
        disabled = true;
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
        if (cache != null && cache.size() > 0) {
            FileCache.clearCache(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessFile acquireCacheOnly(String location) {
        if (disabled) {
            return null;
        }
        if (cache == null) {
            FileCache.init();
        }
        RandomAccessFile raf = null;
        Object object = lock;
        synchronized (object) {
            for (CacheElement elem : cache) {
                if (!elem.location.equals(location) || elem.isLocked) continue;
                elem.isLocked = true;
                raf = elem.raf;
                break;
            }
        }
        if (raf != null) {
            try {
                raf.synch();
            }
            catch (IOException e) {
                log.error("FileCache.synch failed on " + location + " " + e.getMessage());
            }
        }
        return raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessFile acquire(String location) throws IOException {
        boolean needCleanup;
        RandomAccessFile raf = FileCache.acquireCacheOnly(location);
        if (raf != null) {
            return raf;
        }
        raf = new RandomAccessFile(location, "r");
        if (disabled) {
            return raf;
        }
        Object object = lock;
        synchronized (object) {
            cache.add(new CacheElement(raf));
            needCleanup = cache.size() > maxElements;
        }
        if (needCleanup) {
            timer.schedule((TimerTask)new CleanupTask(), 10L);
        }
        return raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(RandomAccessFile raf) throws IOException {
        if (raf == null) {
            return;
        }
        if (disabled) {
            raf.close();
            return;
        }
        String location = raf.getLocation();
        Object object = lock;
        synchronized (object) {
            for (CacheElement elem : cache) {
                if (!elem.location.equals(location) || !elem.isLocked) continue;
                elem.isLocked = false;
                elem.lastAccessed = System.currentTimeMillis();
                ++elem.countAccessed;
                return;
            }
        }
        throw new IOException("FileCache.release does not have in cache = " + location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        int size = cache.size();
        if (size <= minElements) {
            return;
        }
        int count = 0;
        int need2delete = size - minElements;
        ArrayList<CacheElement> deleteList = new ArrayList<CacheElement>();
        Object object = lock;
        synchronized (object) {
            Collections.sort(cache);
            Iterator<CacheElement> iter = cache.iterator();
            while (iter.hasNext()) {
                CacheElement elem = iter.next();
                if (!elem.isLocked) {
                    iter.remove();
                    deleteList.add(elem);
                    ++count;
                }
                if (count < need2delete) continue;
                break;
            }
        }
        long start = System.currentTimeMillis();
        for (CacheElement elem : deleteList) {
            if (!elem.raf.isCached()) {
                log.warn("FileCache file cache flag not set " + elem.location);
            }
            try {
                elem.raf.setCached(false);
                elem.raf.close();
                elem.raf = null;
            }
            catch (IOException e) {
                log.error("FileCache.close failed on " + elem.location);
            }
        }
        long took = System.currentTimeMillis() - start;
        if (log.isDebugEnabled()) {
            log.debug("FileCache.cleanup had= " + size + " deleted= " + count + " took=" + took + " msec");
        }
        if (count < need2delete) {
            log.warn("FileCache.cleanup couldnt delete enough for minimum= " + minElements + " actual= " + cache.size());
        }
    }

    public static List<CacheElement> getCache() {
        return cache == null ? new ArrayList<CacheElement>() : new ArrayList<CacheElement>(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(boolean force) {
        ArrayList<CacheElement> oldcache;
        if (null == cache) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (force) {
                oldcache = new ArrayList<CacheElement>(cache);
                cache.clear();
            } else {
                oldcache = new ArrayList(cache.size());
                Iterator<CacheElement> iter = cache.iterator();
                while (iter.hasNext()) {
                    CacheElement elem = iter.next();
                    if (elem.isLocked) continue;
                    iter.remove();
                    oldcache.add(elem);
                }
            }
        }
        for (CacheElement elem : oldcache) {
            if (elem.isLocked) {
                log.warn("FileCache close locked file= " + elem);
            }
            if (!elem.raf.isCached()) {
                log.warn("FileCache file cache flag not set= " + elem);
            }
            try {
                elem.raf.setCached(false);
                elem.raf.close();
                elem.raf = null;
            }
            catch (IOException e) {
                log.error("FileCache.close failed on " + elem);
            }
        }
    }

    static {
        lock = new Object();
        disabled = true;
    }

    private static class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        public void run() {
            FileCache.cleanup();
        }
    }

    public static class CacheElement
    implements Comparable {
        public String location;
        public RandomAccessFile raf;
        public boolean isLocked = true;
        public int countAccessed = 0;
        public long lastAccessed = 0L;

        CacheElement(RandomAccessFile raf) {
            this.location = raf.getLocation();
            this.raf = raf;
            raf.setCached(true);
        }

        public String toString() {
            return this.location + " " + this.isLocked + " " + this.countAccessed + " " + new Date(this.lastAccessed);
        }

        public int compareTo(Object o) {
            CacheElement e = (CacheElement)o;
            return (int)(this.lastAccessed - e.lastAccessed);
        }
    }
}

