/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import ucar.bufr.Index;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

public class Index2NC {
    private NetcdfFile ncfile;
    private PrintStream out = System.out;
    private Structure recordStructure = null;
    private Structure levelStructure = null;
    private boolean setTime = true;
    private boolean setLat = true;
    private boolean setLon = true;
    private boolean setHgt = true;
    private HashMap dimensions = new HashMap();
    private ArrayList parameters;

    void open(Index index, NetcdfFile ncf, CancelTask cancelTask) {
        this.ncfile = ncf;
        HashMap atts = index.getGlobalAttributes();
        boolean pointDS = false;
        boolean stationDS = false;
        boolean trajectoryDS = false;
        boolean satelliteDS = false;
        String category = (String)atts.get("category");
        if (category.startsWith("4 Single")) {
            trajectoryDS = true;
        } else if (category.startsWith("2 Vertical")) {
            stationDS = true;
        } else if (category.startsWith("3 Vertical")) {
            satelliteDS = true;
        } else {
            pointDS = true;
        }
        this.parameters = index.getParameters();
        this.recordStructure = new Structure(this.ncfile, this.ncfile.getRootGroup(), null, "record");
        Dimension stnsDim = null;
        Dimension levelsDim = null;
        Dimension trajsDim = null;
        if (stationDS) {
            stnsDim = new Dimension("stns", index.getLocations().size(), true, false, false);
            this.ncfile.addDimension(null, stnsDim);
        } else if (trajectoryDS) {
            trajsDim = new Dimension("trajectories", index.getLocations().size(), true, false, false);
            this.ncfile.addDimension(null, trajsDim);
        } else if (satelliteDS) {
            levelsDim = new Dimension("levels", 41, true, false, false);
            this.ncfile.addDimension(null, levelsDim);
        }
        Dimension obsDim = new Dimension("obs", index.getNumberObs(), true, true, false);
        this.ncfile.addDimension(null, obsDim);
        this.recordStructure.setDimensions(obsDim.getName());
        for (int i = 0; i < this.parameters.size(); ++i) {
            String dim;
            Index.parameter p = (Index.parameter)this.parameters.get(i);
            if (p.dimension == 1 || this.dimensions.containsKey(dim = "dim" + Integer.toString(p.dimension))) continue;
            if (p.dimension > 10) {
                this.dimensions.put(dim, levelsDim);
                continue;
            }
            Dimension d = new Dimension(dim, p.dimension, true, false, false);
            this.ncfile.addDimension(null, d);
            this.dimensions.put(dim, d);
        }
        this.ncfile.addAttribute(null, new Attribute("Conventions", "Unidata Observation Dataset v1.0"));
        this.ncfile.addAttribute(null, new Attribute("observationDimension", "obs"));
        if (stationDS) {
            this.ncfile.addAttribute(null, new Attribute("stationsDimension", "stns"));
            this.ncfile.addAttribute(null, new Attribute("parent_index_coordinate", "record.parent_index"));
        } else if (trajectoryDS) {
            this.ncfile.addAttribute(null, new Attribute("trajectoryDimension", "trajectories"));
        }
        this.ncfile.addAttribute(null, new Attribute("time_coverage_start", (String)index.getObsTimes().get(0)));
        this.ncfile.addAttribute(null, new Attribute("time_coverage_end", (String)index.getObsTimes().get(index.getObsTimes().size() - 1)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_max", "90"));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_min", "-90"));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_max", "360"));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_min", "0"));
        if (pointDS || satelliteDS) {
            this.ncfile.addAttribute(null, new Attribute("cdm_data_type", thredds.catalog.DataType.POINT.toString()));
        } else if (stationDS) {
            this.ncfile.addAttribute(null, new Attribute("cdm_data_type", thredds.catalog.DataType.STATION.toString()));
        } else if (trajectoryDS) {
            this.ncfile.addAttribute(null, new Attribute("cdm_data_type", thredds.catalog.DataType.TRAJECTORY.toString()));
        }
        if (stationDS) {
            this.createStnNC(stnsDim, levelsDim);
        } else if (trajectoryDS) {
            this.createTrajNC(trajsDim);
        } else if (satelliteDS) {
            this.createSatVertNC(levelsDim);
        } else {
            ArrayList<Dimension> dl = new ArrayList<Dimension>();
            for (int i = 0; i < this.parameters.size(); ++i) {
                Index.parameter p = (Index.parameter)this.parameters.get(i);
                if (p.dimension != 1) {
                    String dim = "dim" + Integer.toString(p.dimension);
                    Dimension d = (Dimension)this.dimensions.get(dim);
                    dl.add(d);
                    this.addVariable(this.recordStructure, dl, p);
                    dl.remove(0);
                    continue;
                }
                this.addVariable(this.recordStructure, dl, p);
            }
        }
        this.ncfile.addVariable(null, this.recordStructure);
        this.ncfile.finish();
    }

    void createStnNC(Dimension stnsDim, Dimension levelsDim) {
        ArrayList<Dimension> dl = new ArrayList<Dimension>();
        ArrayList<Dimension> ds = new ArrayList<Dimension>();
        ds.add(stnsDim);
        Variable v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "number_stations");
        v.addAttribute(new Attribute("long_name", "number of stations"));
        v.setDimensions(dl);
        v.setDataType(DataType.INT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "station_id");
        v.addAttribute(new Attribute("long_name", "Station Identification"));
        v.setDimensions(ds);
        v.setDataType(DataType.STRING);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "firstChild");
        v.addAttribute(new Attribute("long_name", "firstChild for this station"));
        v.setDimensions(ds);
        v.setDataType(DataType.INT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "numChildren");
        v.addAttribute(new Attribute("long_name", "number of obs for this station"));
        v.setDimensions(ds);
        v.setDataType(DataType.INT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "latitude");
        v.addAttribute(new Attribute("long_name", "latitude for this station"));
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lat"));
        this.setLat = false;
        v.setDimensions(ds);
        v.setDataType(DataType.FLOAT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "longitude");
        v.addAttribute(new Attribute("long_name", "longitude for this station"));
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lon"));
        this.setLon = false;
        v.setDimensions(ds);
        v.setDataType(DataType.FLOAT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "altitude");
        v.addAttribute(new Attribute("long_name", "altitude for this station"));
        v.addAttribute(new Attribute("_CoordinateAxisType", "Height"));
        this.setHgt = false;
        v.setDimensions(ds);
        v.setDataType(DataType.INT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, "parent_index");
        v.addAttribute(new Attribute("long_name", "index of this station for the record"));
        v.setDimensions(dl);
        v.setDataType(DataType.INT);
        this.recordStructure.addMemberVariable(v);
        boolean levelIncrement = false;
        for (int i = 0; i < this.parameters.size(); ++i) {
            Dimension d;
            Index.parameter p = (Index.parameter)this.parameters.get(i);
            if (p.key.equals("0-7-5")) {
                levelIncrement = true;
                d = new Dimension("dim43", 43, true, false, false);
                this.ncfile.addDimension(null, d);
                this.dimensions.put("dim43", d);
                d = new Dimension("dim86", 86, true, false, false);
                this.ncfile.addDimension(null, d);
                this.dimensions.put("dim86", d);
            }
            if (p.key.equals("0-5-1") || p.key.equals("0-5-2") || p.key.equals("0-6-1") || p.key.equals("0-6-2") || p.key.equals("0-7-1") || p.key.equals("0-7-2") || p.key.equals("0-1-18")) continue;
            if (p.key.equals("0-2-134") || p.key.equals("0-2-135") || p.key.equals("0-7-5")) {
                d = (Dimension)this.dimensions.get("dim3");
                dl.add(d);
                this.addVariable(this.recordStructure, dl, p);
                dl.remove(0);
                continue;
            }
            if (levelIncrement && p.dimension != 1) {
                d = p.key.equals("0-8-22") ? (Dimension)this.dimensions.get("dim86") : (Dimension)this.dimensions.get("dim43");
                dl.add(d);
                this.addVariable(this.recordStructure, dl, p);
                dl.remove(0);
                continue;
            }
            if (p.dimension != 1) {
                if (this.levelStructure == null) {
                    levelsDim = new Dimension("levels", Dimension.VLEN.getLength(), true, false, true);
                    this.ncfile.addDimension(null, levelsDim);
                    this.levelStructure = new Structure(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, "level");
                    this.levelStructure.setDimensions(levelsDim.getName());
                }
                this.addVariable(this.levelStructure, dl, p);
                continue;
            }
            this.addVariable(this.recordStructure, dl, p);
        }
        if (this.levelStructure != null) {
            this.recordStructure.addMemberVariable(this.levelStructure);
        }
    }

    void createTrajNC(Dimension trajsDim) {
        ArrayList<Dimension> dl = new ArrayList<Dimension>();
        ArrayList<Dimension> dt = new ArrayList<Dimension>();
        dt.add(trajsDim);
        Variable v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "number_trajectories");
        v.addAttribute(new Attribute("long_name", "number of trajectories"));
        v.setDimensions(dl);
        v.setDataType(DataType.INT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "trajectory_id");
        v.addAttribute(new Attribute("long_name", "Trajectory Identification"));
        v.setDimensions(dt);
        v.setDataType(DataType.STRING);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "firstChild");
        v.addAttribute(new Attribute("long_name", "firstChild for this trajectory"));
        v.setDimensions(dt);
        v.setDataType(DataType.INT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, "numChildren");
        v.addAttribute(new Attribute("long_name", "number of obs in this trajectory"));
        v.setDimensions(dt);
        v.setDataType(DataType.INT);
        this.ncfile.addVariable(null, v);
        v = new Variable(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, "parent_index");
        v.addAttribute(new Attribute("long_name", "index of this trajectory for the record"));
        v.setDimensions(dl);
        v.setDataType(DataType.INT);
        this.recordStructure.addMemberVariable(v);
        for (int i = 0; i < this.parameters.size(); ++i) {
            Index.parameter p = (Index.parameter)this.parameters.get(i);
            if (p.dimension != 1) {
                String dim = "dim" + Integer.toString(p.dimension);
                Dimension d = (Dimension)this.dimensions.get(dim);
                dl.add(d);
                this.addVariable(this.recordStructure, dl, p);
                dl.remove(0);
                continue;
            }
            this.addVariable(this.recordStructure, dl, p);
        }
    }

    void createSatVertNC(Dimension levelsDim) {
        Dimension dim35 = new Dimension("dim35", 35, true, false, false);
        this.ncfile.addDimension(null, dim35);
        this.dimensions.put("dim35", dim35);
        Dimension dim40 = new Dimension("dim40", 40, true, false, false);
        this.ncfile.addDimension(null, dim40);
        this.dimensions.put("dim40", dim40);
        ArrayList<Dimension> dl = new ArrayList<Dimension>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            Index.parameter p = (Index.parameter)this.parameters.get(i);
            if (p.dimension != 1) {
                Dimension d;
                if (p.key.equals("0-5-42") || p.key.equals("0-12-63")) {
                    d = (Dimension)this.dimensions.get("dim35");
                } else if (p.key.equals("0-13-2")) {
                    d = (Dimension)this.dimensions.get("dim40");
                } else {
                    String dim = "dim" + Integer.toString(p.dimension);
                    d = (Dimension)this.dimensions.get(dim);
                }
                dl.add(d);
                this.addVariable(this.recordStructure, dl, p);
                dl.remove(0);
                continue;
            }
            this.addVariable(this.recordStructure, dl, p);
        }
    }

    void addVariable(Structure struct, ArrayList dims, Index.parameter parm) {
        Variable v;
        if (parm.key.equals("0-4-250")) {
            v = new Variable(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, "time_observation");
            if (this.setTime) {
                v.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
            }
            this.setTime = false;
        } else if (parm.key.equals("0-5-1") || parm.key.equals("0-5-2") || parm.key.equals("0-27-1") || parm.key.equals("0-27-2")) {
            v = new Variable(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, parm.name);
            if (this.setLat) {
                v.addAttribute(new Attribute("_CoordinateAxisType", "Lat"));
            }
            this.setLat = false;
        } else if (parm.key.equals("0-6-1") || parm.key.equals("0-6-2") || parm.key.equals("0-28-1") || parm.key.equals("0-28-2")) {
            v = new Variable(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, parm.name);
            if (this.setLon) {
                v.addAttribute(new Attribute("_CoordinateAxisType", "Lon"));
            }
            this.setLon = false;
        } else if (parm.key.equals("0-7-1") || parm.key.equals("0-7-2") || parm.key.equals("0-7-6")) {
            v = new Variable(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, parm.name);
            if (this.setHgt) {
                v.addAttribute(new Attribute("_CoordinateAxisType", "Height"));
            }
            this.setHgt = false;
        } else {
            v = new Variable(this.ncfile, this.ncfile.getRootGroup(), this.recordStructure, parm.name);
        }
        v.addAttribute(new Attribute("Bufr_key", parm.key));
        if (parm.name.equals("time_observation")) {
            v.setDataType(DataType.INT);
        } else if (parm.isNumeric) {
            v.setDataType(DataType.FLOAT);
            v.addAttribute(new Attribute("MissingValue", "-9999"));
        } else {
            v.setDataType(DataType.STRING);
        }
        v.setDimensions(dims);
        if (!parm.units.equals("")) {
            v.addAttribute(new Attribute("units", parm.units));
        }
        struct.addMemberVariable(v);
    }
}

