/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterTypeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterTypeEnumHandler.class);
    private static final Hashtable<String, String> patterns = FilterTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Dichroic\\s*", "Dichroic");
        p.put("^\\s*LongPass\\s*", "LongPass");
        p.put("^\\s*ShortPass\\s*", "ShortPass");
        p.put("^\\s*BandPass\\s*", "BandPass");
        p.put("^\\s*MultiPass\\s*", "MultiPass");
        p.put("^\\s*NeutralDensity\\s*", "NeutralDensity");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return FilterType.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"FilterType", (Object)value);
        return FilterType.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return FilterType.class;
    }
}

