/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Polygon
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Polygon.class);
    private String points;

    public Polygon() {
    }

    public Polygon(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Polygon".equals(tagName)) {
            LOGGER.debug("Expecting node name of Polygon got {}", (Object)tagName);
        }
        if (element.hasAttribute("Points")) {
            this.setPoints(String.valueOf(element.getAttribute("Points")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Polygon_element) {
        if (Polygon_element == null) {
            Polygon_element = document.createElementNS(NAMESPACE, "Polygon");
        }
        if (this.points != null) {
            Polygon_element.setAttribute("Points", this.points.toString());
        }
        return super.asXMLElement(document, Polygon_element);
    }
}

