/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.filesystem;

import loci.poi.poifs.filesystem.DirectoryEntry;
import loci.poi.poifs.filesystem.DirectoryNode;
import loci.poi.poifs.filesystem.Entry;
import loci.poi.poifs.property.Property;

public abstract class EntryNode
implements Entry {
    private Property _property;
    private DirectoryNode _parent;

    protected EntryNode(Property property, DirectoryNode parent) {
        this._property = property;
        this._parent = parent;
    }

    protected Property getProperty() {
        return this._property;
    }

    protected boolean isRoot() {
        return this._parent == null;
    }

    protected abstract boolean isDeleteOK();

    public String getName() {
        return this._property.getName();
    }

    public boolean isDirectoryEntry() {
        return false;
    }

    public boolean isDocumentEntry() {
        return false;
    }

    public DirectoryEntry getParent() {
        return this._parent;
    }

    public boolean delete() {
        boolean rval = false;
        if (!this.isRoot() && this.isDeleteOK()) {
            rval = this._parent.deleteEntry(this);
        }
        return rval;
    }

    public boolean renameTo(String newName) {
        boolean rval = false;
        if (!this.isRoot()) {
            rval = this._parent.changeName(this.getName(), newName);
        }
        return rval;
    }
}

