/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class SlidebookReader
extends FormatReader {
    public static final int SLD_MAGIC_BYTES_1_0 = 108;
    public static final int SLD_MAGIC_BYTES_1_1 = 256;
    public static final int SLD_MAGIC_BYTES_1_2 = 512;
    public static final int SLD_MAGIC_BYTES_2_0 = 501;
    public static final int SLD_MAGIC_BYTES_2_1 = 258;
    public static final long SLD_MAGIC_BYTES_3 = 4127260929L;
    private Vector<Long> metadataOffsets;
    private Vector<Long> pixelOffsets;
    private Vector<Long> pixelLengths;
    private Vector<Double> ndFilters;
    private Hashtable<Integer, String> imageDescriptions;
    private long[][] planeOffset;
    private boolean adjust = true;
    private boolean isSpool;
    private Hashtable<Integer, Integer> metadataInPlanes;

    public SlidebookReader() {
        super("Olympus Slidebook", new String[]{"sld", "spl"});
        this.domains = new String[]{"Light Microscopy"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        stream.seek(4L);
        boolean littleEndian = stream.readString(2).equals("II");
        if (!FormatTools.validStream(stream, 8, littleEndian)) {
            return false;
        }
        short magicBytes1 = stream.readShort();
        short magicBytes2 = stream.readShort();
        return !((magicBytes2 & 0xFF00) != 256 && (magicBytes2 & 0xFF00) != 512 || magicBytes1 != 108 && magicBytes1 != 501);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long offset = this.planeOffset[this.getSeries()][no];
        this.in.seek(offset);
        int[] zct = this.getZCTCoords(no);
        if (this.isSpool) {
            long len = this.pixelLengths.get(this.getSeries());
            long planeSize = FormatTools.getPlaneSize(this);
            long diff = len - (long)this.getImageCount() * planeSize;
            this.in.seek(this.in.getFilePointer() - diff);
            Object[] keys = this.metadataInPlanes.keySet().toArray(new Integer[0]);
            Arrays.sort(keys);
            Object[] arr$ = keys;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int key = (Integer)arr$[i$];
                if (key >= no) continue;
                this.in.skipBytes(256);
            }
            long beginning = this.in.getFilePointer();
            for (int i = 0; i < 8; ++i) {
                if (this.in.getFilePointer() + 4L >= this.in.length()) {
                    this.in.seek(beginning);
                    break;
                }
                this.in.order(false);
                long magicBytes = (long)this.in.readInt() & 0xFFFFFFFFL;
                this.in.order(this.isLittleEndian());
                if (magicBytes == 4127260929L && !this.metadataInPlanes.contains(no)) {
                    this.metadataInPlanes.put(no, 0);
                    this.in.skipBytes(252);
                    break;
                }
                if (i == 7) {
                    this.in.seek(beginning);
                    continue;
                }
                this.in.skipBytes(252);
            }
        }
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelLengths = null;
            this.pixelOffsets = null;
            this.metadataOffsets = null;
            this.ndFilters = null;
            this.isSpool = false;
            this.metadataInPlanes = null;
            this.adjust = true;
            this.planeOffset = null;
            this.imageDescriptions = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int i2;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.isSpool = SlidebookReader.checkSuffix(id, "spl");
        if (this.isSpool) {
            this.metadataInPlanes = new Hashtable();
        }
        LOGGER.info("Finding offsets to pixel data");
        this.in.skipBytes(4);
        this.core[0].littleEndian = this.in.read() == 73;
        this.in.order(this.isLittleEndian());
        this.metadataOffsets = new Vector();
        this.pixelOffsets = new Vector();
        this.pixelLengths = new Vector();
        this.ndFilters = new Vector();
        this.imageDescriptions = new Hashtable();
        this.in.seek(0L);
        while (this.in.getFilePointer() < this.in.length() - 8L) {
            LOGGER.debug("Looking for block at {}", this.in.getFilePointer());
            this.in.skipBytes(4);
            int checkOne = this.in.read();
            int checkTwo = this.in.read();
            if (checkOne == 73 && checkTwo == 73 || checkOne == 77 && checkTwo == 77) {
                LOGGER.debug("Found metadata offset: {}", this.in.getFilePointer() - 6L);
                this.metadataOffsets.add(new Long(this.in.getFilePointer() - 6L));
                this.in.skipBytes(this.in.readShort() - 8);
                continue;
            }
            if (checkOne == -1 && checkTwo == -1) {
                boolean foundBlock = false;
                byte[] block = new byte[8192];
                this.in.read(block);
                while (!foundBlock) {
                    for (i2 = 0; i2 < block.length - 2; ++i2) {
                        if ((block[i2] != 77 || block[i2 + 1] != 77) && (block[i2] != 73 || block[i2 + 1] != 73)) continue;
                        foundBlock = true;
                        this.in.seek(this.in.getFilePointer() - (long)block.length + (long)i2 - 2L);
                        LOGGER.debug("Found metadata offset: {}", this.in.getFilePointer() - 2L);
                        this.metadataOffsets.add(new Long(this.in.getFilePointer() - 2L));
                        this.in.skipBytes(this.in.readShort() - 5);
                        break;
                    }
                    if (foundBlock) continue;
                    block[0] = block[block.length - 2];
                    block[1] = block[block.length - 1];
                    this.in.read(block, 2, block.length - 2);
                }
                continue;
            }
            String s = null;
            long fp = this.in.getFilePointer() - 6L;
            this.in.seek(fp);
            int len = this.in.read();
            if (len > 0 && len <= 32) {
                s = this.in.readString(len);
            }
            if (s != null && s.indexOf("Annotation") != -1) {
                if (s.equals("CTimelapseAnnotation")) {
                    this.in.skipBytes(41);
                    if (this.in.read() == 0) {
                        this.in.skipBytes(10);
                        continue;
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CIntensityBarAnnotation")) {
                    this.in.skipBytes(56);
                    int n = this.in.read();
                    while (n == 0 || n < 6 || n > 128) {
                        n = this.in.read();
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CCubeAnnotation")) {
                    this.in.skipBytes(66);
                    int n = this.in.read();
                    if (n == 0) continue;
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (!s.equals("CScaleBarAnnotation")) continue;
                this.in.skipBytes(38);
                int extra = this.in.read();
                if (extra <= 16) {
                    this.in.skipBytes(3 + extra);
                    continue;
                }
                this.in.skipBytes(2);
                continue;
            }
            if (s != null && s.indexOf("Decon") != -1) {
                this.in.seek(fp);
                while (this.in.read() != 93) {
                }
                continue;
            }
            if (fp % 2L == 1L) {
                fp -= 2L;
            }
            this.in.seek(fp);
            String checkString = this.in.readString(64);
            if (checkString.indexOf("II") != -1 || checkString.indexOf("MM") != -1) {
                int index = checkString.indexOf("II");
                if (index == -1) {
                    index = checkString.indexOf("MM");
                }
                this.in.seek(fp + (long)index - 4L);
                continue;
            }
            this.in.seek(fp);
            LOGGER.debug("Found pixel offset at {}", fp);
            this.pixelOffsets.add(new Long(fp));
            try {
                byte[] buf = new byte[8192];
                boolean found = false;
                int n = this.in.read(buf);
                while (!found && this.in.getFilePointer() < this.in.length()) {
                    for (int i3 = 0; i3 < n - 6; ++i3) {
                        if ((buf[i3 + 4] != 73 || buf[i3 + 5] != 73) && (buf[i3 + 4] != 77 || buf[i3 + 5] != 77)) continue;
                        if ((buf[i3] == 104 || buf[i3] == 105) && buf[i3 + 1] == 0 || buf[i3] == 0 && (buf[i3 + 1] == 104 || buf[i3 + 1] == 105)) {
                            found = true;
                            this.in.seek(this.in.getFilePointer() - (long)n + (long)i3 - 20L);
                            if (buf[i3] != 105 && buf[i3 + 1] != 105) break;
                            this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
                            break;
                        }
                        if ((buf[i3] != 106 && buf[i3] != 107 && buf[i3] != 110 || buf[i3 + 1] != 0) && (buf[i3] != 0 || buf[i3 + 1] != 106 && buf[i3 + 1] != 107 && buf[i3 + 1] != 110) && (buf[i3] != 111 || buf[i3 + 1] != 110)) continue;
                        found = true;
                        this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
                        this.in.seek(this.in.getFilePointer() - (long)n + (long)i3 - 20L);
                        break;
                    }
                    if (found) continue;
                    byte[] tmp = buf;
                    buf = new byte[8192];
                    System.arraycopy(tmp, tmp.length - 20, buf, 0, 20);
                    n = this.in.read(buf, 20, buf.length - 20);
                }
                if (this.in.getFilePointer() <= this.in.length()) {
                    if (this.pixelOffsets.size() <= this.pixelLengths.size()) continue;
                    long length = this.in.getFilePointer() - fp;
                    if (length / 2L % 2L == 1L) {
                        this.pixelOffsets.setElementAt(fp + 2L, this.pixelOffsets.size() - 1);
                        length -= 2L;
                    }
                    if (length >= 1024L) {
                        this.pixelLengths.add(new Long(length));
                        continue;
                    }
                    this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
                    continue;
                }
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
            catch (EOFException e) {
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
        }
        Vector<Long> orderedSeries = new Vector<Long>();
        Hashtable uniqueSeries = new Hashtable();
        for (int i4 = 0; i4 < this.pixelOffsets.size(); ++i4) {
            int padding;
            long length = this.pixelLengths.get(i4);
            long offset = this.pixelOffsets.get(i4);
            int n = padding = this.isSpool ? 0 : 7;
            if (length + offset + (long)padding > this.in.length()) {
                this.pixelOffsets.remove(i4);
                this.pixelLengths.remove(i4);
                --i4;
                continue;
            }
            Vector<Integer> v = (Vector<Integer>)uniqueSeries.get(length);
            if (v == null) {
                orderedSeries.add(length);
                v = new Vector<Integer>();
            }
            v.add(i4);
            uniqueSeries.put(length, v);
        }
        if (this.pixelOffsets.size() > 1) {
            boolean little = this.isLittleEndian();
            int seriesCount = 0;
            for (i2 = 0; i2 < uniqueSeries.size(); ++i2) {
                Vector pixelIndexes = (Vector)uniqueSeries.get(orderedSeries.get(i2));
                int nBlocks = pixelIndexes.size();
                if (nBlocks == 0) {
                    ++nBlocks;
                }
                seriesCount += nBlocks;
            }
            this.core = new CoreMetadata[seriesCount];
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                this.core[i2] = new CoreMetadata();
                this.core[i2].littleEndian = little;
            }
        }
        LOGGER.info("Determining dimensions");
        Hashtable<Integer, Float> pixelSize = new Hashtable<Integer, Float>();
        Hashtable<Integer, String> objectives = new Hashtable<Integer, String>();
        Hashtable<Integer, Integer> magnifications = new Hashtable<Integer, Integer>();
        Vector<Double> pixelSizeZ = new Vector<Double>();
        Vector<Integer> exposureTimes = new Vector<Integer>();
        long pixelBytes = 0L;
        for (int i5 = 0; i5 < this.pixelLengths.size(); ++i5) {
            pixelBytes += this.pixelLengths.get(i5).longValue();
        }
        String[] imageNames = new String[this.getSeriesCount()];
        Vector<String> channelNames = new Vector<String>();
        int nextName = 0;
        int[] sizeX = new int[this.pixelOffsets.size()];
        int[] sizeY = new int[this.pixelOffsets.size()];
        int[] sizeZ = new int[this.pixelOffsets.size()];
        int[] sizeC = new int[this.pixelOffsets.size()];
        int[] divValues = new int[this.pixelOffsets.size()];
        int iCount = 0;
        int hCount = 0;
        int uCount = 0;
        int prevSeries = -1;
        int prevSeriesU = -1;
        boolean nextChannel = false;
        block15: for (int i6 = 0; i6 < this.metadataOffsets.size(); ++i6) {
            long off = this.metadataOffsets.get(i6);
            if (this.isSpool && off == 0L) {
                off = 276L;
            }
            this.in.seek(off);
            long next = i6 == this.metadataOffsets.size() - 1 ? this.in.length() : this.metadataOffsets.get(i6 + 1).longValue();
            int totalBlocks = (int)((next - off) / 128L);
            block16: for (int q = 0; q < totalBlocks; ++q) {
                short div;
                if (this.withinPixels(off + (long)(q * 128))) continue;
                this.in.seek(off + (long)q * 128L);
                char n = (char)this.in.readShort();
                while (n == '\u0000' && this.in.getFilePointer() < off + (long)((q + 1) * 128)) {
                    n = (char)this.in.readShort();
                }
                if (this.in.getFilePointer() >= this.in.length() - 2L) continue block15;
                if (n == 'i') {
                    ++iCount;
                    this.in.skipBytes(70);
                    int expTime = this.in.readInt();
                    if (expTime > 0) {
                        exposureTimes.add(expTime);
                    }
                    this.in.skipBytes(20);
                    Double size = new Double(this.in.readFloat());
                    if (this.isGreaterThanEpsilon(size)) {
                        pixelSizeZ.add(size);
                    } else {
                        pixelSizeZ.add(null);
                    }
                    this.in.seek(this.in.getFilePointer() - 20L);
                    for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                        long end;
                        long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (sizeX[j] == 0) {
                            short x = this.in.readShort();
                            short y = this.in.readShort();
                            if (x != 0 && y != 0) {
                                sizeX[j] = x;
                                sizeY[j] = y;
                                short checkX = this.in.readShort();
                                short checkY = this.in.readShort();
                                div = this.in.readShort();
                                if (checkX == checkY) {
                                    divValues[j] = div;
                                    int n2 = j;
                                    sizeX[n2] = sizeX[n2] / (div == 0 ? (short)1 : div);
                                    div = this.in.readShort();
                                    int n3 = j;
                                    sizeY[n3] = sizeY[n3] / (div == 0 ? (short)1 : div);
                                }
                            } else {
                                this.in.skipBytes(8);
                            }
                        }
                        if (prevSeries != j) {
                            iCount = 1;
                        }
                        prevSeries = j;
                        sizeC[j] = iCount;
                        continue block16;
                    }
                    continue;
                }
                if (n == 'u') {
                    ++uCount;
                    for (int j = 0; j < this.getSeriesCount(); ++j) {
                        long end;
                        long l = end = j == this.getSeriesCount() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (prevSeriesU != j) {
                            uCount = 1;
                        }
                        prevSeriesU = j;
                        sizeZ[j] = uCount;
                        continue block16;
                    }
                    continue;
                }
                if (n == 'h') {
                    ++hCount;
                    continue;
                }
                if (n == 'j') {
                    String name;
                    this.in.skipBytes(2);
                    String check = this.in.readString(2);
                    if (!check.equals("II") && !check.equals("MM")) continue;
                    long pointer = this.in.getFilePointer();
                    this.in.skipBytes(10);
                    if (nextName < imageNames.length && (name = this.in.readCString().trim()).length() > 0) {
                        imageNames[nextName++] = name;
                    }
                    long fp = this.in.getFilePointer();
                    if (this.in.getFilePointer() % 2L == 1L) {
                        this.in.skipBytes(1);
                    }
                    while (this.in.readShort() == 0) {
                    }
                    if (this.in.readShort() == 0) {
                        this.in.skipBytes(4);
                    } else {
                        this.in.skipBytes(16);
                    }
                    long diff = this.in.getFilePointer() - fp;
                    if (diff > 123L && fp % 2L == 0L && diff != 142L && diff != 143L && diff != 130L) {
                        this.in.seek(fp + 123L);
                    }
                    int x = this.in.readInt();
                    int y = this.in.readInt();
                    if (x > 32768 || y > 32768) {
                        this.in.seek(this.in.getFilePointer() - 7L);
                        x = this.in.readInt();
                        y = this.in.readInt();
                    } else if (x == 0 || y == 0) {
                        this.in.seek(this.in.getFilePointer() - 27L);
                        x = this.in.readInt();
                        y = this.in.readInt();
                    }
                    div = this.in.readShort();
                    int n4 = div == 0 || div > 256 ? 1 : (int)div;
                    div = this.in.readShort();
                    if ((x /= n4) > 65536 || (y /= div == 0 || div > 256 ? 1 : (int)div) > 65536) {
                        this.in.seek(this.in.getFilePointer() - 11L);
                        x = this.in.readInt();
                        y = this.in.readInt();
                        div = this.in.readShort();
                        short s = div == 0 ? (short)1 : div;
                        div = this.in.readShort();
                        if ((x /= s) > 65536 || (y /= div == 0 ? (short)1 : div) > 65536) {
                            this.in.skipBytes(2);
                            x = this.in.readInt();
                            y = this.in.readInt();
                            div = this.in.readShort();
                            x /= div == 0 ? (short)1 : div;
                            div = this.in.readShort();
                            y /= div == 0 ? (short)1 : div;
                        }
                    }
                    if (!(nextName < 1 || x <= 16 || x >= sizeX[nextName - 1] && sizeX[nextName - 1] != 0 || y <= 16 || y >= sizeY[nextName - 1] && sizeY[nextName - 1] != 0)) {
                        sizeX[nextName - 1] = x;
                        sizeY[nextName - 1] = y;
                        this.adjust = false;
                    }
                    this.in.seek(pointer + 214L);
                    short validBits = this.in.readShort();
                    if (nextName < 1 || this.core[nextName - 1].bitsPerPixel != 0 || validBits > 16) continue;
                    this.core[nextName - 1].bitsPerPixel = validBits;
                    continue;
                }
                if (n == 'm') {
                    if (this.in.getFilePointer() <= this.pixelOffsets.get(0) && !this.isSpool) continue;
                    this.in.skipBytes(14);
                    String name = this.in.readCString().trim();
                    if (name.length() <= 1) continue;
                    channelNames.add(name);
                    continue;
                }
                if (n == 'd') {
                    float v;
                    this.in.skipBytes(6);
                    long fp = this.in.getFilePointer();
                    while (this.in.read() == 0) {
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    long nSkipped = this.in.getFilePointer() - fp;
                    if (nSkipped < 8L) {
                        this.in.skipBytes((int)(8L - nSkipped));
                    }
                    String objective = this.in.readCString().trim();
                    this.in.seek(fp + 144L);
                    float pixSize = this.in.readFloat();
                    short magnification = this.in.readShort();
                    int mult = 1;
                    if (pixelSize.size() < divValues.length) {
                        mult = divValues[pixelSize.size()];
                    }
                    if (!this.isGreaterThanEpsilon(v = pixSize * (float)mult)) continue;
                    pixelSize.put(nextName - 1, Float.valueOf(v));
                    objectives.put(nextName - 1, objective);
                    magnifications.put(nextName - 1, Integer.valueOf(magnification));
                    continue;
                }
                if (n == 'e') {
                    this.in.skipBytes(174);
                    this.ndFilters.add(new Double(this.in.readFloat()));
                    this.in.skipBytes(40);
                    if (nextName < 0 || nextName >= this.getSeriesCount()) continue;
                    this.setSeries(nextName);
                    this.addSeriesMeta("channel " + this.ndFilters.size() + " intensification", this.in.readShort());
                    continue;
                }
                if (n == 'k') {
                    this.in.skipBytes(14);
                    if (nextName > 0) {
                        this.setSeries(nextName - 1);
                    }
                    this.addSeriesMeta("Mag. changer", this.in.readCString());
                    continue;
                }
                if (n == 'n') {
                    long fp1 = this.in.getFilePointer();
                    this.in.seek(this.in.getFilePointer() - 3L);
                    while (this.in.read() != 0) {
                        this.in.seek(this.in.getFilePointer() - 2L);
                    }
                    long fp2 = this.in.getFilePointer();
                    int len = this.in.read() - 1;
                    int currentSeries = 0;
                    for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                        long end;
                        long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        currentSeries = j;
                        break;
                    }
                    if (len <= 0 || fp1 - fp2 == 2L) continue;
                    if (fp2 < fp1) {
                        this.in.seek(this.in.getFilePointer() - 1L);
                        String descr = this.in.readCString();
                        descr = descr.substring(0, descr.length() - 2);
                        if (descr.endsWith("Annotatio")) continue;
                        this.imageDescriptions.put(currentSeries, descr.trim());
                        continue;
                    }
                    this.imageDescriptions.put(currentSeries, this.in.readString(len).trim());
                    continue;
                }
                if (!this.isSpool) continue;
                for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                    long end;
                    long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                    if (this.in.getFilePointer() >= end) continue;
                    this.in.skipBytes(14);
                    short check = this.in.readShort();
                    short x = this.in.readShort();
                    short y = this.in.readShort();
                    if (check == 0 && x > 16 && y > 16) {
                        sizeX[j] = x;
                        sizeY[j] = y;
                    }
                    this.adjust = false;
                    continue block16;
                }
            }
        }
        String currentName = imageNames[0];
        Vector<CoreMetadata> realCore = new Vector<CoreMetadata>();
        int t = 1;
        boolean noFlattening = currentName != null && currentName.equals("Untitled");
        for (int i7 = 1; i7 < this.getSeriesCount(); ++i7) {
            if (imageNames[i7] == null || !imageNames[i7].equals(currentName) || noFlattening || i7 == 1 && (sizeX[i7 - 1] != sizeX[i7] || sizeY[i7 - 1] != sizeY[i7] || sizeC[i7 - 1] != sizeC[i7] || sizeZ[i7 - 1] != sizeZ[i7])) {
                currentName = imageNames[i7];
                CoreMetadata nextCore = this.core[i7 - 1];
                nextCore.sizeT = t;
                realCore.add(nextCore);
                if (t == 1) {
                    noFlattening = true;
                }
                t = 1;
                if (i7 != 1) continue;
                noFlattening = true;
                continue;
            }
            ++t;
        }
        this.core[this.getSeriesCount() - 1].sizeT = t;
        realCore.add(this.core[this.getSeriesCount() - 1]);
        boolean flattened = false;
        if (this.core.length != realCore.size() && !noFlattening) {
            flattened = true;
            this.core = realCore.toArray(new CoreMetadata[realCore.size()]);
            orderedSeries.clear();
            uniqueSeries.clear();
            int nextIndex = 0;
            for (int i8 = 0; i8 < this.core.length; ++i8) {
                long thisSeries = i8;
                orderedSeries.add(thisSeries);
                Vector<Integer> indexes = new Vector<Integer>();
                indexes.add(nextIndex);
                uniqueSeries.put(thisSeries, indexes);
                long length = this.pixelLengths.get(nextIndex);
                this.pixelLengths.setElementAt(length *= (long)this.core[i8].sizeT, i8);
                nextIndex += this.core[i8].sizeT;
            }
        }
        this.planeOffset = new long[this.getSeriesCount()][];
        boolean divByTwo = false;
        boolean divZByTwo = false;
        int nextPixelIndex = 0;
        int nextBlock = 0;
        int nextOffsetIndex = 0;
        for (int i9 = 0; i9 < this.getSeriesCount(); ++i9) {
            int z;
            boolean cGreater;
            this.setSeries(i9);
            Vector pixelIndexes = (Vector)uniqueSeries.get(orderedSeries.get(nextPixelIndex));
            int nBlocks = pixelIndexes.size();
            if (nextBlock >= nBlocks) {
                nextBlock = 0;
                pixelIndexes = (Vector)uniqueSeries.get(orderedSeries.get(++nextPixelIndex));
                nBlocks = pixelIndexes.size();
            } else {
                ++nextBlock;
            }
            int index = pixelIndexes.size() == this.getSeriesCount() ? (Integer)pixelIndexes.get(0) : i9;
            long pixels = this.pixelLengths.get(index) / 2L;
            boolean x = true;
            this.core[i9].sizeX = sizeX[index];
            this.core[i9].sizeY = sizeY[index];
            this.core[i9].sizeC = sizeC[index];
            this.core[i9].sizeZ = sizeZ[index];
            if (this.getSizeC() > 64) {
                this.core[i9].sizeC = 1;
                this.core[i9].sizeZ = 1;
                this.core[i9].sizeX /= 2;
                this.core[i9].sizeY /= 2;
            }
            boolean isMontage = false;
            if (i9 > 1 && (imageNames[i9] != null && imageNames[i9].startsWith("Montage") || this.getSizeC() >= 32)) {
                this.core[i9].sizeC = this.core[1].sizeC;
                this.core[i9].sizeZ = this.core[1].sizeZ;
                isMontage = true;
            }
            boolean bl = cGreater = this.core[i9].sizeC > this.core[i9].sizeZ;
            if (this.isSpool && this.core[i9].sizeC == 0) {
                this.core[i9].sizeC = channelNames.size();
            }
            if (this.core[i9].sizeZ % nBlocks == 0 && nBlocks != this.getSizeC() && (z = this.core[i9].sizeZ / nBlocks) <= nBlocks) {
                this.core[i9].sizeZ = z;
            }
            if (divByTwo) {
                this.core[i9].sizeX /= 2;
            }
            if (divZByTwo && this.core[i9].sizeC > 1) {
                this.core[i9].sizeZ = (int)(pixels / (long)(this.core[i9].sizeX * this.core[i9].sizeY) / 2L);
                this.core[i9].sizeC = 2;
            }
            if (this.getSizeC() == 0) {
                this.core[i9].sizeC = 1;
            }
            if (this.getSizeZ() == 0) {
                this.core[i9].sizeZ = 1;
            }
            long plane = pixels / (long)(this.getSizeC() * this.getSizeZ());
            if (this.getSizeT() > 0) {
                plane /= (long)this.getSizeT();
            }
            if ((long)(this.getSizeX() * this.getSizeY()) == pixels) {
                if (this.getSizeC() == 2 && this.getSizeX() % 2 == 0 && this.getSizeY() % 2 == 0) {
                    if (this.getSizeC() != this.getSizeZ()) {
                        this.core[i9].sizeX /= 2;
                        divByTwo = true;
                    } else {
                        divZByTwo = true;
                        this.core[i9].sizeC = 1;
                    }
                } else {
                    this.core[i9].sizeC = 1;
                }
                this.core[i9].sizeZ = 1;
            } else if ((long)(this.getSizeX() * this.getSizeY() * this.getSizeZ()) == pixels) {
                if (this.getSizeC() == 2 && this.getSizeC() != this.getSizeZ() && this.getSizeX() % 2 == 0 && this.getSizeY() % 2 == 0 && (i9 == 0 || this.core[i9 - 1].sizeC > 1)) {
                    this.core[i9].sizeX /= 2;
                    divByTwo = true;
                } else {
                    this.core[i9].sizeC = 1;
                    this.core[i9].sizeZ = (int)(pixels / (long)(this.getSizeX() * this.getSizeY()));
                }
            } else if ((long)(this.getSizeX() * this.getSizeY() * this.getSizeC()) == pixels) {
                this.core[i9].sizeC = (int)(pixels / (long)(this.getSizeX() * this.getSizeY()));
                this.core[i9].sizeZ = 1;
            } else if ((long)(this.getSizeX() / 2 * (this.getSizeY() / 2) * this.getSizeZ()) == pixels) {
                this.core[i9].sizeX /= 2;
                this.core[i9].sizeY /= 2;
            } else if ((long)(this.getSizeX() / 2 * (this.getSizeY() / 2) * this.getSizeC() * this.getSizeZ() * this.getSizeT()) == pixels) {
                this.core[i9].sizeX /= 2;
                this.core[i9].sizeY /= 2;
            } else {
                int originalX;
                long p;
                boolean validSizes = true;
                try {
                    DataTools.safeMultiply32(this.getSizeX(), this.getSizeY());
                }
                catch (IllegalArgumentException e) {
                    validSizes = false;
                }
                if (this.getSizeX() == 0 || this.getSizeY() == 0 || !validSizes) {
                    this.core[i9].sizeX = sizeX[index] / 256;
                    this.core[i9].sizeY = sizeY[index] / 256;
                }
                if (pixels == (p = pixels / (long)(this.getSizeX() * this.getSizeY())) * (long)this.getSizeX() * (long)this.getSizeY()) {
                    if (p != (long)(this.getSizeC() * this.getSizeZ())) {
                        if (this.getSizeC() > 1 && (long)this.core[i9].sizeZ >= p / (long)(this.getSizeC() - 1) && p >= (long)(this.getSizeC() - 1) && p > 2L) {
                            --this.core[i9].sizeC;
                            this.core[i9].sizeZ = (int)(p / (long)this.getSizeC());
                        } else if (p % (long)this.getSizeC() != 0L) {
                            this.core[i9].sizeC = 1;
                            this.core[i9].sizeZ = (int)p;
                        } else if ((long)this.core[i9].sizeZ == p + 1L) {
                            this.core[i9].sizeC = 1;
                            this.core[i9].sizeZ = 1;
                            this.core[i9].sizeT = (int)p;
                        } else if (this.getSizeC() > 1 && (long)this.core[i9].sizeZ == p / (long)(this.getSizeC() - 1) + 1L) {
                            --this.core[i9].sizeC;
                            this.core[i9].sizeZ = 1;
                            this.core[i9].sizeT = (int)(p / (long)this.getSizeC());
                        } else if (p > (long)this.getSizeZ() && p / (long)this.getSizeZ() < (long)(this.getSizeZ() - 1)) {
                            this.core[i9].sizeT = (int)(p / (long)this.getSizeC());
                            this.core[i9].sizeZ = 1;
                        } else if (pixels % (long)this.getSizeX() == 0L && pixels % (long)this.getSizeY() == 0L) {
                            while ((long)(this.getSizeX() * this.getSizeY()) > plane) {
                                this.core[i9].sizeX /= 2;
                                this.core[i9].sizeY /= 2;
                            }
                            originalX = this.getSizeX();
                            while ((long)(this.getSizeX() * this.getSizeY()) < plane) {
                                this.core[i9].sizeX += originalX;
                                this.core[i9].sizeY = (int)(plane / (long)this.getSizeX());
                            }
                            int newX = this.getSizeX() + originalX;
                            if ((long)newX * (plane / (long)newX) == plane && !flattened) {
                                this.core[i9].sizeX = newX;
                                this.core[i9].sizeY = (int)(plane / (long)newX);
                            }
                        } else if (!this.adjust) {
                            this.core[i9].sizeZ = (int)(p / (long)this.getSizeC());
                        } else if (isMontage) {
                            pixels /= (long)this.getSizeC();
                            while (pixels != (long)(this.getSizeX() * this.getSizeY()) || this.getSizeY() / this.getSizeX() > 2) {
                                this.core[i9].sizeX += 16;
                                this.core[i9].sizeY = (int)(pixels / (long)this.getSizeX());
                            }
                        }
                    }
                } else if (this.isSpool) {
                    this.core[i9].sizeZ = (int)(p / (long)this.getSizeC());
                } else if (p == 0L) {
                    this.adjust = true;
                    if (this.getSizeC() > 1) {
                        this.core[i9].sizeC = this.getSizeC() == 3 ? 2 : 1;
                    }
                } else if (this.core[i9].sizeC > 1 && p <= (long)this.core[i9].sizeC) {
                    int z2 = this.getSizeZ();
                    this.core[i9].sizeZ = 1;
                    this.core[i9].sizeC = (int)p;
                    this.core[i9].sizeT = 1;
                    if (isMontage && pixels == (long)this.getSizeX() * (pixels / (long)this.getSizeX())) {
                        pixels /= (long)this.getSizeC();
                        while (pixels != (long)(this.getSizeX() * this.getSizeY())) {
                            this.core[i9].sizeX -= 16;
                            this.core[i9].sizeY = (int)(pixels / (long)this.getSizeX());
                        }
                    } else if (!isMontage) {
                        this.core[i9].sizeZ = z2;
                        this.adjust = true;
                    }
                } else if (isMontage) {
                    int newY;
                    int newX;
                    boolean xGreater;
                    pixels /= (long)(this.getSizeC() * this.getSizeZ());
                    originalX = this.getSizeX();
                    int originalY = this.getSizeY();
                    boolean bl2 = xGreater = this.getSizeX() > this.getSizeY();
                    while (this.getSizeX() * this.getSizeY() != 0 && (pixels % (long)(this.getSizeX() * this.getSizeY()) != 0L || (double)this.getSizeY() / (double)this.getSizeX() > 2.0)) {
                        this.core[i9].sizeX += originalX;
                        this.core[i9].sizeY = (int)(pixels / (long)this.getSizeX());
                        if (xGreater || this.getSizeX() < this.getSizeY()) continue;
                    }
                    if (this.getSizeX() * this.getSizeY() == 0 && pixels != (long)(this.getSizeX() * this.getSizeY())) {
                        pixels *= (long)(this.getSizeC() * this.getSizeZ());
                        this.core[i9].sizeX = originalX;
                        this.core[i9].sizeY = originalY;
                        isMontage = false;
                    }
                    if (pixels % (long)(originalX - originalX / 4) == 0L && (long)((newX = originalX - originalX / 4) * (newY = (int)(pixels / (long)newX))) == pixels) {
                        this.core[i9].sizeX = newX;
                        this.core[i9].sizeY = newY;
                        isMontage = true;
                        this.adjust = false;
                    }
                } else if (p != (long)(this.getSizeZ() * this.getSizeC())) {
                    if (pixels % (long)this.getSizeX() == 0L && pixels % (long)this.getSizeY() == 0L) {
                        while ((long)(this.getSizeX() * this.getSizeY()) > plane) {
                            this.core[i9].sizeX /= 2;
                            this.core[i9].sizeY /= 2;
                        }
                    } else {
                        this.core[i9].sizeZ = 1;
                        this.core[i9].sizeC = 1;
                        this.core[i9].sizeT = (int)p;
                    }
                }
            }
            if (this.getSizeC() == 0) {
                this.core[i9].sizeC = 1;
            }
            if (this.getSizeZ() == 0) {
                this.core[i9].sizeZ = 1;
            }
            int div = this.getSizeC() * this.getSizeZ();
            if (this.getSizeT() > 0) {
                div *= this.getSizeT();
            }
            if (div > 1) {
                plane = pixels / (long)div;
            }
            long diff = 2L * (pixels - (long)(this.getSizeX() * this.getSizeY() * div));
            if (this.pixelLengths.get(index) % 2L == 1L) {
                ++diff;
            }
            if (Math.abs(diff) > plane / 2L) {
                diff = 0L;
            }
            if (this.adjust && diff == 0L) {
                boolean widthGreater;
                double ratio = (double)this.getSizeX() / (double)this.getSizeY();
                boolean bl3 = widthGreater = this.getSizeX() > this.getSizeY();
                while ((long)(this.getSizeX() * this.getSizeY()) > plane) {
                    if (x) {
                        this.core[i9].sizeX /= 2;
                    } else {
                        this.core[i9].sizeY /= 2;
                    }
                    x = !x;
                }
                if ((long)(this.getSizeX() * this.getSizeY()) != plane) {
                    while (ratio - (double)this.getSizeX() / (double)this.getSizeY() >= 0.01) {
                        boolean first = true;
                        while (first || (long)(this.getSizeX() * this.getSizeY()) < plane || this.getSizeX() < this.getSizeY() && widthGreater) {
                            if (first) {
                                first = false;
                            }
                            ++this.core[i9].sizeX;
                            this.core[i9].sizeY = (int)(plane / (long)this.getSizeX());
                        }
                    }
                }
            }
            int nPlanes = this.getSizeZ() * this.getSizeC();
            this.core[i9].sizeT = (int)(pixels / (long)(this.getSizeX() * this.getSizeY() * nPlanes));
            while ((long)(this.getSizeX() * this.getSizeY() * nPlanes * this.getSizeT()) > pixels) {
                --this.core[i9].sizeT;
            }
            if (this.getSizeT() == 0) {
                this.core[i9].sizeT = 1;
            }
            if (cGreater && this.getSizeC() == 1 && this.getSizeZ() > 1) {
                this.core[i9].sizeC = this.getSizeZ();
                this.core[i9].sizeZ = 1;
            }
            this.core[i9].imageCount = nPlanes * this.getSizeT();
            this.core[i9].pixelType = 3;
            this.core[i9].dimensionOrder = nBlocks > 1 ? "XYZCT" : "XYZTC";
            this.core[i9].indexed = false;
            this.core[i9].falseColor = false;
            this.core[i9].metadataComplete = true;
            this.planeOffset[i9] = new long[this.getImageCount()];
            int nextImage = 0;
            Integer pixelIndex = i9;
            long offset = this.pixelOffsets.get(pixelIndex);
            int planeSize = this.getSizeX() * this.getSizeY() * 2;
            offset = diff < (long)planeSize ? (offset += diff) : (offset += diff % (long)planeSize);
            long length = this.pixelLengths.get(pixelIndex);
            int planes = (int)(length / (long)planeSize);
            if (planes > this.core[i9].imageCount) {
                planes = this.core[i9].imageCount;
            }
            int p = 0;
            while (p < planes) {
                int[] zct = this.getZCTCoords(p);
                if (flattened && zct[0] == 0 && zct[1] == 0) {
                    offset = this.pixelOffsets.get(nextOffsetIndex++);
                    if (zct[2] > 0 && this.planeOffset[i9][nextImage - 1] % 2L != offset % 2L && offset - this.planeOffset[i9][nextImage - 1] > (long)(3 * this.getSizeX() * this.getSizeY()) && diff == 0L) {
                        diff = 31L;
                    }
                    offset = diff < (long)planeSize ? (offset += diff) : (offset += diff % (long)planeSize);
                    this.planeOffset[i9][nextImage] = offset;
                } else if (flattened && zct[0] == 0) {
                    int idx = this.getIndex(0, 0, zct[2]);
                    this.planeOffset[i9][nextImage] = this.planeOffset[i9][idx] + (long)(zct[1] * planeSize);
                } else if (flattened) {
                    this.planeOffset[i9][nextImage] = this.planeOffset[i9][nextImage - 1] + (long)planeSize;
                } else if (nextImage < this.planeOffset[i9].length) {
                    this.planeOffset[i9][nextImage] = offset + (long)(p * planeSize);
                }
                ++p;
                ++nextImage;
            }
        }
        this.setSeries(0);
        if (pixelSizeZ.size() > 0) {
            int seriesIndex = 0;
            for (int q = 0; q < this.getSeriesCount(); ++q) {
                int inc = this.core[q].sizeC * this.core[q].sizeT;
                if (seriesIndex + inc > pixelSizeZ.size()) {
                    int z = this.core[q].sizeT;
                    this.core[q].sizeT = this.core[q].sizeZ;
                    this.core[q].sizeZ = z;
                    inc = this.core[q].sizeC * this.core[q].sizeT;
                }
                seriesIndex += inc;
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (imageNames[i] == null) continue;
            store.setImageName(imageNames[i], i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i10;
            for (i = 0; i < this.getSeriesCount(); ++i) {
                if (this.imageDescriptions.containsKey(i)) {
                    store.setImageDescription(this.imageDescriptions.get(i), i);
                    continue;
                }
                store.setImageDescription("", i);
            }
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            for (int i11 = 0; i11 < this.getSeriesCount(); ++i11) {
                store.setImageInstrumentRef(instrumentID, i11);
            }
            int index = 0;
            int objectiveIndex = 0;
            for (int i12 = 0; i12 < this.getSeriesCount(); ++i12) {
                String objective = (String)objectives.get(i12);
                if (objective == null) continue;
                store.setObjectiveModel(objective, 0, objectiveIndex);
                store.setObjectiveCorrection(this.getCorrection("Other"), 0, objectiveIndex);
                store.setObjectiveImmersion(this.getImmersion("Other"), 0, objectiveIndex);
                if (magnifications != null && (Integer)magnifications.get(i12) > 0) {
                    store.setObjectiveNominalMagnification(new PositiveInteger((Integer)magnifications.get(i12)), 0, objectiveIndex);
                }
                String objectiveID = MetadataTools.createLSID("Objective", 0, objectiveIndex);
                store.setObjectiveID(objectiveID, 0, objectiveIndex);
                if (i12 < this.getSeriesCount()) {
                    store.setObjectiveSettingsID(objectiveID, i12);
                }
                ++objectiveIndex;
            }
            int exposureIndex = exposureTimes.size() - channelNames.size();
            if (exposureIndex >= 1) {
                ++exposureIndex;
            }
            for (i10 = 0; i10 < this.getSeriesCount(); ++i10) {
                this.setSeries(i10);
                if (pixelSize.get(i10) != null) {
                    Double size = new Double(((Float)pixelSize.get(i10)).floatValue());
                    if (size > 0.0) {
                        store.setPixelsPhysicalSizeX(new PositiveFloat(size), i10);
                        store.setPixelsPhysicalSizeY(new PositiveFloat(size), i10);
                    } else {
                        LOGGER.warn("Expected positive value for PhysicalSize; got {}", size);
                    }
                }
                int idx = 0;
                for (int q = 0; q < i10; ++q) {
                    idx += this.core[q].sizeC * this.core[q].sizeT;
                }
                if (idx < pixelSizeZ.size() && pixelSizeZ.get(idx) != null) {
                    if (this.isGreaterThanEpsilon((Double)pixelSizeZ.get(idx))) {
                        store.setPixelsPhysicalSizeZ(new PositiveFloat((Double)pixelSizeZ.get(idx)), i10);
                    } else {
                        LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", pixelSizeZ.get(idx));
                    }
                }
                for (int plane = 0; plane < this.getImageCount(); ++plane) {
                    int c = this.getZCTCoords(plane)[1];
                    if (exposureIndex + c >= exposureTimes.size() || exposureIndex + c < 0) continue;
                    store.setPlaneExposureTime(new Double(((Integer)exposureTimes.get(exposureIndex + c)).intValue()), i10, plane);
                }
                exposureIndex += this.getSizeC();
            }
            this.setSeries(0);
            for (i10 = 0; i10 < this.getSeriesCount(); ++i10) {
                this.setSeries(i10);
                for (int c = 0; c < this.getSizeC(); ++c) {
                    if (index < channelNames.size() && channelNames.get(index) != null) {
                        store.setChannelName((String)channelNames.get(index), i10, c);
                        this.addSeriesMeta("channel " + c, channelNames.get(index));
                    }
                    if (index < this.ndFilters.size() && this.ndFilters.get(index) != null) {
                        store.setChannelNDFilter(this.ndFilters.get(index), i10, c);
                        this.addSeriesMeta("channel " + c + " Neutral density", this.ndFilters.get(index));
                    }
                    ++index;
                }
            }
            this.setSeries(0);
        }
    }

    private boolean withinPixels(long offset) {
        for (int i = 0; i < this.pixelOffsets.size(); ++i) {
            long pixelOffset = this.pixelOffsets.get(i);
            long pixelLength = this.pixelLengths.get(i);
            if (offset < pixelOffset || offset >= pixelOffset + pixelLength) continue;
            return true;
        }
        return false;
    }

    private boolean isGreaterThanEpsilon(double v) {
        return v - 1.0E-6 > 0.0;
    }
}

