function writeDocumentation( documentation, fileID )
% WRITEDOCUMENTATION Helper function that handles the writing of the
% documentation of an SLML file

% Author: Ivan E. Cao-Berg (icaoberg@cmu.edu)
% Created: December 15, 2007
% Last Update: February 15, 2008
%
% Copyright (C) 2008  Murphy Lab
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu/software or
% send email to murphy@cmu.edu

if( isempty( documentation ) )
    return;
else
    fprintf( fileID, '\t%s\n', '<documentation>' );
    fields = fieldnames( documentation );
    for( i=1:1:length(fields) )
        name = fields{i};
        value = getfield( documentation, name ); %#ok<GFLD>
        fprintf( fileID, '\t\t%s\n', ['<meta name="' name '" value="' ...
            value '" />'] );
    end
    fprintf( fileID, '\t\t%s\n', ['<meta name="date" value="' ...
        date '" />'] );
end
fprintf( fileID, '\t%s\n', '</documentation>' );
end%writeDocumentation