function varargout = trainer( varargin )
% TRAINER M-file for trainer.fig
%      TRAINER, by itself, creates a new TRAINER or raises the existing
%      singleton*.
%
%      H = TRAINER returns the handle to a new TRAINER or the handle to
%      the existing singleton*.
%
%      TRAINER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TRAINER.M with the given input arguments.
%
%      TRAINER('Property','Value',...) creates a new TRAINER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before trainer_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to trainer_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Author: Ivan E. Cao-Berg (icaoberg@scs.cmu.edu)
% March 9, 2012 Added license, documentation and updated the
%               opening and closing function
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

% Edit the above text to modify the response to help trainer

% Last Modified by GUIDE v2.5 14-Dec-2011 13:05:15

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @trainer_OpeningFcn, ...
    'gui_OutputFcn',  @trainer_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

function trainer_OpeningFcn(hObject, eventdata, handles, varargin)
%pixels
set( handles.slmlModelTrainer, ...
    'Units', 'pixels' );

%get your display size
screenSize = get(0, 'ScreenSize');

position = get( handles.slmlModelTrainer, ...
    'Position' );

position(1) = (screenSize(3)-position(3))/2;
position(2) = (screenSize(4)-position(4))/2;

set( handles.slmlModelTrainer, ...
    'Position', position );

%slml instance filename
handles.slmlInstanceFileName = '';

set( handles.copyright, ...
    'String', 'Copyright (c) Murphy Lab at Carnegie Mellon University' );

% Choose default command line output for trainer
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

function varargout = trainer_OutputFcn(hObject, eventdata, handles)
varargout{1} = handles.output;


function nuclearModelImageCollectionPath_Callback(hObject, eventdata, handles)

function nuclearModelImageCollectionPath_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function slmlInstanceList_Callback(hObject, eventdata, handles)

function slmlInstanceList_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function cellModelImageCollection_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function cellModelImageCollection_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function proteinModelImageCollection_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function proteinModelImageCollection_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function targetDirectoryPath_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function targetDirectoryPath_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function slmlInstanceFilename_Callback(hObject, eventdata, handles)
set( handles.slmlInstanceFilename, ...
    'String', slmlInstanceFilename );
guidata( hObject, handles );

% --- Executes during object creation, after setting all properties.
function slmlInstanceFilename_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%nuclearModelImageCollection
function nuclearModelImageCollection_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function nuclearModelImageCollection_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%targetDirectory
function targetDirectory_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function targetDirectory_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%BUTTONS
%resetButton
function resetButton_Callback(hObject, eventdata, handles)

%clear texts
set( handles.nuclearModelImageCollection, ...
    'String', '' );
set( handles.cellModelImageCollection, ...
    'String', '' );
set( handles.proteinModelImageCollection, ...
    'String', '' );
set( handles.targetDirectory, ...
    'String', '' );
set( handles.slmlInstanceFilename, ...
    'String', '' );

% %clear variables
% set( handles.nuclearModelImageCollection, ...
%     'String', '' );
% set( handles.cellModelImageCollection, ...
%     'String', '' );
% set( handles.proteinModelImageCollection, ...
%     'String', '' );
% set( handles.targetDirectory, ...
%     'String', '' );
% set( handles.slmlInstanceFilename, ...
%     'String', '' );

guidata( hObject, handles );

%exitButton
function exitButton_Callback(hObject, eventdata, handles)
if( isdeployed )
    exit;
else
    close;
end

%selectNuclearModelImageCollectionButton
function selectNuclearModelImageCollectionButton_Callback(hObject, eventdata, handles)
%on-click
directory = uigetdir( pwd, 'Select Image Directory' );

%in case user press cancel
if isequal(directory,0) || isempty( directory )
    set( handles.nuclearModelImageCollection, ...
        'String', '' );
else
    %set text
    set( handles.nuclearModelImageCollection, ...
        'String', directory );
end

guidata( hObject, handles );

%selectCellModelImageCollectionButton
function selectCellModelImageCollectionButton_Callback(hObject, eventdata, handles)
%on-click
directory = uigetdir( pwd, 'Select Image Directory' );

%in case user press cancel
if isequal(directory,0) || isempty( directory )
    set( handles.cellModelImageCollection, ...
        'String', '' );
else
    %set text
    set( handles.cellModelImageCollection, ...
        'String', directory );
end

guidata( hObject, handles );

%selectProteinModelImageCollectionButton.
function selectProteinModelImageCollectionButton_Callback(hObject, eventdata, handles)
%on-click
directory = uigetdir( pwd, 'Select Image Directory' );

%in case user press cancel
if isequal(directory,0) || isempty( directory )
    set( handles.proteinModelImageCollection, ...
        'String', '' );
else
    %set text
    set( handles.proteinModelImageCollection, ...
        'String', directory );
end

% images = getImages( handles.proteinModelImageCollectionDirectory, 'tif' );
% if isempty( images )
%     slmlErrorMessage( 'Protein Model Image Collection', ...
%         'No images were found on the selected directory.' );
%     set( handles.proteinModelImageCollectionDirectory, ...
%         'String', '' );
%     set( handles.proteinModelImageCollection, ...
%         'String', '' );
% end

guidata( hObject, handles );

%selectTargetDirectoryButton.
function selectTargetDirectoryButton_Callback(hObject, eventdata, handles)
%on-click
directory = uigetdir( pwd, 'Select Target Directory' );

%in case user press cancel
if isequal(directory,0) || isempty( directory )
    set( handles.targetDirectory, ...
        'String', '' );
else
    %set text
    set( handles.targetDirectory, ...
        'String', directory );
end

guidata( hObject, handles );

%trainModelButton
function trainModelButton_Callback( hObject, eventdata, handles )

%icaoberg added warning dialogs to improve user experience
nuclearModelImageCollection = get( handles.nuclearModelImageCollection, ...
    'String' );
cellModelImageCollection = get( handles.cellModelImageCollection, ...
    'String' );
proteinModelImageCollection = get( handles.proteinModelImageCollection, ...
    'String' );
targetDirectory = get( handles.targetDirectory, ...
    'String' );
slmlInstanceFilename = get( handles.slmlInstanceFilename, ...
    'String' );

%get dimensionality from GUI
dimensions = get( handles.dimensionalityMenu, 'String' );
dimensionality = dimensions{get( handles.dimensionalityMenu, 'Value' )};

if isempty( nuclearModelImageCollection )
    warndlg( ['Generative model cannot be trained because the nuclear ' ...
        'images data directory is empty. Select a directory and try again.'] );
elseif isempty( cellModelImageCollection ) && strcmpi( dimensionality, '2D' )
    warndlg( ['Generative model cannot be trained because the cell ' ...
        'images data directory is empty. Select a directory and try again.'] );
elseif isempty( proteinModelImageCollection ) && strcmpi( dimensionality, '2D' )
    warndlg( ['Generative model cannot be trained because the protein ' ...
        'images data directory is empty. Select a directory and try again.'] );
elseif isempty( targetDirectory )
    warndlg( ['Generative model cannot be trained because target ' ...
        'directory is empty. Select a directory and try again.'] );
elseif isempty( targetDirectory )
    warndlg( ['Generative model cannot be trained because the SLML ' ...
        'instance filename was left empty. Select a directory and try again.'] );
else
    % generic options
    % ---------------
    param.verbose = true;
    param.debug = true;
    
    % generic model options
    % ---------------------
    % model.name                (optional) Holds the name of the model. Default is empty.
    param.model.name = 'all';
    
    % model.id                  (optional) Holds the id of the model. Default is empty.
    try
        [status,result] = system( 'uuidgen' );
        param.model.id = result(1:end-1);
    catch err
        param.model.id = num2str(now);
    end
    
    % model.filename            Holds the output filename.
    param.model.filename = [ targetDirectory filesep slmlInstanceFilename ];
    
    % nuclear shape model options
    % ---------------------------
    % nucleus.type              Holds the nuclear model type. Default is "medial axis".
    param.nucleus.type = 'medial axis';
    
    % nucleus.name              (optional) Holds the name of the nuclear model. Default is empty.
    param.nucleus.name = 'all';
    
    % nucleus.id                (optional) Holds the id of the nuclear model. Default is empty.
    try
        [status,result] = system( 'uuidgen' );
        param.nucleus.id = result(1:end-1);
    catch err
        param.nucleus.id = num2str(now);
    end
    
    % cell shape model options
    % ------------------------
    % cell.type                 Holds the cell model type. Default is "ratio".
    param.cell.type = 'ratio';
    
    % cell.name                 (optional) Holds the name of the cell model. Default is empty.
    param.cell.model = 'framework';
    
    % cell.id                   (optional) Holds the id the cell model. Default is empty.
    try
        [status,result] = system( 'uuidgen' );
        param.cell.id = result(1:end-1);
    catch err
        param.cell.id = num2str(now);
    end
    
    % other options
    % -------------
    % verbose                   (optional) Displays messages to screen. The default is true.
    param.verbose = true;
    
    % debug                     (optional) Reports errors and warnings. Default is false.
    param.debug = true;
    
    % train.flag                (optional) Selects what model is going to be trained ('nuclear',
    %                           'framework', or 'all'). Default is 'all'
    param.train.flag = 'framework';
    
    %documentation
    param.documentation.author = 'Unknown';
    param.documentation.email = 'unknown';
    param.documentation.description = 'This generative model was trained using the trainer tool in CellOrganizer';
    
    param.isshow = false;
    
    if strcmpi( dimensionality, '2D' )
        img2slml( dimensionality, nuclearModelImageCollection, cellModelImageCollection, ...
            proteinModelImageCollection, param );
    else
        img2slml( dimensionality, nuclearModelImageCollection, nuclearModelImageCollection, ...
            nuclearModelImageCollection, param );
    end
    
    guidata( hObject, handles );
end

% --- Executes on selection change in dimensionalityMenu.
function dimensionalityMenu_Callback(hObject, eventdata, handles)
%icaoberg added functionality so that menu changes depending on the image
%type
value = get( handles.dimensionalityMenu, 'Value' );

if value == 1 %2D
    set( handles.text1, 'String', 'Nuclear Model Image Collection' )
    set( handles.text2, 'Visible', 'on' )
    set( handles.text3, 'Visible', 'on' )
    set( handles.cellModelImageCollection, 'Visible', 'on' )
    set( handles.proteinModelImageCollection, 'Visible', 'on' )
    set( handles.selectCellModelImageCollectionButton, 'Visible', 'on' )
    set( handles.selectProteinModelImageCollectionButton, 'Visible', 'on' )
else %3D
    set( handles.text1, 'String', 'Image Collection' )
    set( handles.text2, 'Visible', 'off' )
    set( handles.text3, 'Visible', 'off')
    set( handles.cellModelImageCollection, 'Visible', 'off' )
    set( handles.proteinModelImageCollection, 'Visible', 'off' )
    set( handles.selectCellModelImageCollectionButton, 'Visible', 'off' )
    set( handles.selectProteinModelImageCollectionButton, 'Visible', 'off' )
end

% --- Executes during object creation, after setting all properties.
function dimensionalityMenu_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
