function varargout = toolbar(varargin)
% TOOLBAR M-file for toolbar.fig
%      TOOLBAR, by itself, creates a new TOOLBAR or raises the existing
%      singleton*.
%
%      H = TOOLBAR returns the handle to a new TOOLBAR or the handle to
%      the existing singleton*.
%
%      TOOLBAR('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TOOLBAR.M with the given input arguments.
%
%      TOOLBAR('Property','Value',...) creates a new TOOLBAR or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before toolbar_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to toolbar_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help toolbar

% Last Modified by GUIDE v2.5 17-Feb-2012 10:17:36

% Author: Ivan E. Cao-Berg (icaoberg@scs.cmu.edu)
% March 9, 2012 Added license, updated opening and closing 
%               functions and removed support for gallery
%
% Copyright (C) 2007-2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @toolbar_OpeningFcn, ...
                   'gui_OutputFcn',  @toolbar_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before toolbar is made visible.
function toolbar_OpeningFcn(hObject, eventdata, handles, varargin)

%puts the figure in the upper corner of the screen
screenSize = get( 0, 'ScreenSize' );
position = get( handles.toolbar, ...
    'Position' );
position(2) = 0.95*screenSize(4);
set( handles.toolbar, ...
    'Position', position );

%centers the three buttons in the middle of the gui
align( [handles.trainButton handles.synthesizeButton ...
    handles.exitButton], 'center', 'distribute' );

handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = toolbar_OutputFcn(hObject, eventdata, handles) 
varargout{1} = handles.output;

% --- Executes on button press in trainButton.
function trainButton_Callback(hObject, eventdata, handles)
    trainer;

% --- Executes on button press in synthesizeButton.
function synthesizeButton_Callback(hObject, eventdata, handles)
    synthesizer;
    
% --- Executes on button press in exitButton.
function exitButton_Callback(hObject, eventdata, handles)
%if the code has been deployed as a Matlab binary, then it will exit. if it
%is not deployed then it will close all open figures
if isdeployed
    exit;
else
    close('all');
end

% --------------------------------------------------------------------
function help_menu_Callback(hObject, eventdata, handles)
% hObject    handle to help_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
