function varargout = synthesizer(varargin)
% SYNTHESIZER M-file for synthesizer.fig
%      SYNTHESIZER, by itself, creates a new SYNTHESIZER or raises the existing
%      singleton*.
%
%      H = SYNTHESIZER returns the handle to a new SYNTHESIZER or the handle to
%      the existing singleton*.
%
%      SYNTHESIZER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SYNTHESIZER.M with the given input arguments.
%
%      SYNTHESIZER('Property','Value',...) creates a new SYNTHESIZER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before syntesizer_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to synthesizer_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Author: Ivan E. Cao-Berg (icaoberg@scs.cmu.edu)
% March 9, 2012 Added license, documentation and updated the 
%               opening and closing function
% March 12, 2012 Changed sampling text to "Sampling density"
% April 11, 2012 
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

% Edit the above text to modify the response to help synthesizer

% Last Modified by GUIDE v2.5 04-Mar-2012 21:24:51

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @synthesizer_OpeningFcn, ...
    'gui_OutputFcn',  @synthesizer_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

function synthesizer_OpeningFcn(hObject, eventdata, handles, varargin)

%get your display size
screenSize = get(0, 'ScreenSize');

%main window
set( handles.synthesizer, ...
    'Units', 'pixels' );

position = get( handles.synthesizer, ...
    'Position' );

%center the GUI to the middle of the screen
position(1) = (screenSize(3)-position(3))/2;
position(2) = (screenSize(4)-position(4))/2;

set( handles.synthesizer, ...
    'Position', position );

handles.currentImageIndex  = 0;

set( handles.copyright, ...
    'String', 'Copyright (c) 2007-2012 Carnegie Mellon University' );

set( handles.synthesize3DImagesPanel, ...
    'Visible', 'off' );

set( handles.synthesize2DImagesPanel, ...
    'Visible', 'on' );

set( handles.currentImage, ...
    'Visible', 'on', ...
    'XTick', [], ...
    'YTick', [], ...
    'ZTick', [] );

set( handles.gallery, ...
    'Title', '2D Image Gallery', ...
    'Visible', 'on' );

set( handles.text83, 'Visible', 'off' )
set( handles.numberOfMolecules, 'Visible', 'off' )

set( handles.log3D, ...
    'Position', get( handles.currentImage, 'Position' ));

set( handles.text19, ...
    'Visible', 'off' );
set( handles.firstChannel, ...
    'Visible', 'off' );
set( handles.secondChannel, ...
    'Visible', 'off' );
set( handles.thirdChannel, ...
    'Visible', 'off' );

% Choose default command line output for synthesizer
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

function varargout = synthesizer_OutputFcn(hObject, eventdata, handles)
% Get default command line output from handles structure
varargout{1} = handles.output;

function listOfChannels_Callback(hObject, eventdata, handles)

function listOfChannels_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function listOfSLMLInstances_Callback(hObject, eventdata, handles)

function listOfSLMLInstances_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function add2DSlmlInstanceButton_Callback(hObject, eventdata, handles)
%select SLML instance
[filename, pathname] = uigetfile( {'*.mat'}, 'Select SLML Instance' );

%in case user press cancel
if isequal( filename, 0 ) || isempty( filename )
    return
else
    %get list of slml instances
    listOfSlmlInstances = get( handles.listOf2DSlmlInstances, ...
        'String' );
    cellFrameworkInstance = get( handles.cellFrameworkInstance2D, ...
        'String' );
    
    %if the list is empty, convert it to cell array and populate with the
    %first instance, this is neccesary because when a listbox is empty
    %matlab considers it an empty string rather than an empty cell array
    if isempty( listOfSlmlInstances ) || ischar( listOfSlmlInstances )
        listOfSlmlInstances = {};
        listOfSlmlInstances{1} = fullfile( pathname, filename );
        cellFrameworkInstance = {};
        cellFrameworkInstance{1} = filename;
    else
        %add the current file to the listboxes
        listOfSlmlInstances{ length(listOfSlmlInstances)+1 } = ...
            fullfile( pathname, filename );
        cellFrameworkInstance{ length(cellFrameworkInstance)+1 } = ...
            filename;
    end
    %display the listboxes on screen
    set( handles.listOf2DSlmlInstances, ...
        'String', listOfSlmlInstances );
    set( handles.cellFrameworkInstance2D, ...
        'String', cellFrameworkInstance );
end
guidata( hObject, handles );

function add2DSlmlInstanceButton_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function currentSLMLInstance_Callback(hObject, eventdata, handles)

function currentSLMLInstance_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function targetDirectory2DImages_Callback(hObject, eventdata, handles)

function targetDirectory2DImages_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function numberOfSynthesizedImages_Callback(hObject, eventdata, handles)

function numberOfSynthesizedImages_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function imagesPrefix2D_Callback(hObject, eventdata, handles)

function imagesPrefix2D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function cellFrameworkInstance_Callback(hObject, eventdata, handles)

function cellFrameworkInstance_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function currentSlmlInstance_Callback(hObject, eventdata, handles)

function currentSlmlInstance_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%BUTTONS
function selectTargetDirectory2DButton_Callback(hObject, eventdata, handles)
%on-click
directory = uigetdir( pwd, 'Select Target Directory' );

%in case user press cancel
if isequal(directory,0) || isempty( directory )
    set( handles.targetDirectory2DImages, ...
        'String', '' );
    set( handles.targetDirectory3DImages, ...
        'String', '' );
else
    %display text on screen
    set( handles.targetDirectory2DImages, ...
        'String', directory );
    set( handles.targetDirectory3DImages, ...
        'String', directory );
end

guidata( hObject, handles );

%synthesize3DMultiColorImagesButton
function synthesize3DMultiColorImagesButton_Callback(hObject, eventdata, handles)

if get( handles.sampling, 'Value' ) == 0
    param.sampling.method = 0;
else
    param.sampling.method = 1;
end

if get( handles.sampling, 'Value' ) == 1
    if get( handles.numberOfMolecules, 'Value' ) == 0 | ...
            isempty(get( handles.numberOfMolecules, 'Value' ) )
        param.sampling.N = []
    else
        param.sampling.N;
    end
    
    if get( handles.psf, 'Value' ) == 0
        microscope = 'none';
    else
        microscope = 'vsi';
    end
    
    %check the contents of every uicontrol before synthesizing images
    if isempty( get(handles.listOf3DSlmlInstances, 'String') ) || ...
            ischar( get(handles.listOf3DSlmlInstances ) )
        warndlg( ['Images cannot be synthesized because no '...
            'SLML instances were selected. Add at least one SLML instance to '...
            'the list and try again.'] );
    elseif isempty( get(handles.cellFrameworkInstance3D, 'String') ) || ...
            ischar( get(handles.cellFrameworkInstance3D, 'String') )
        warndlg( ['No target directory was selected. ' ...
            'Select a destination and try again.'] );
    elseif isempty( get(handles.targetDirectory3DImages) ) || ...
            ~isaDir( get(handles.targetDirectory3DImages, 'String') )
        warndlg( ['The target directory does not exist. '...
            'Select an existing directory and try again.'] );
    elseif isempty( get(handles.imagesPrefix3D, 'String') )
        warndlg( ['No images prefix was selected. '...
            'Select a prefix and try again.'] );
    elseif isempty( get(handles.numberOfSynthesizedImages3D, 'String') )
        warndlg( ['No number of synthesized images was '...
            'selected. Select a valid number and try again'] );
    else
        %get list of slml instances with full path
        listOfSlmlInstances = get( handles.listOf3DSlmlInstances, 'String' );
        
        %get compression
        if get( handles.imageCompressionMenu3D, 'Value' ) == 1
            compression = 'none';
        else
            compression = 'packbits';
        end
        
        %select instance for the framework
        cellFrameworkInstanceIndex = get( handles.cellFrameworkInstance3D, 'Value' );
        temporaryFilename = listOfSlmlInstances{1};
        listOfSlmlInstances{1} = listOfSlmlInstances{ cellFrameworkInstanceIndex };
        listOfSlmlInstances{cellFrameworkInstanceIndex} = temporaryFilename;
        
        %paramaters
        targetDirectory = get( handles.targetDirectory3DImages, 'String' );
        imagesPrefix = get( handles.imagesPrefix3D, 'String' );
        numberOfSynthesizedImages = str2double( get( handles.numberOfSynthesizedImages3D, ...
            'String' ));
        
        if length( numberOfSynthesizedImages ) > 1
            numberOfSynthesizedImages = numberOfSynthesizedImages(end);
        end
        
        if ~exist( [ targetDirectory filesep imagesPrefix ] )
            mkdir( [ targetDirectory filesep imagesPrefix ] );
        end
        
        %Prepare parameters for evaluation
        files = {};
        for i=1:1:length(listOfSlmlInstances)
            files{length(files)+1} = listOfSlmlInstances{i}; %#ok<AGROW>
        end
        
        param.microscope = microscope;
        param.targetDirectory = targetDirectory;
        param.prefix = imagesPrefix;
        param.compression = compression;
        param.numberOfSynthesizedImages = numberOfSynthesizedImages;
        slml2img( files, param );
    end
end


% --- Executes on selection change in firstChannel.
function firstChannel_Callback(hObject, eventdata, handles)

currentImage = tif2img( [ get( handles.targetDirectory2DImages, 'String' ) filesep ...
    get( handles.imagesPrefix2D, 'String' ) ...
    num2str(handles.currentImageIndex) '.tif'] );

temp(:,:,1) = currentImage(:,:, get( handles.firstChannel, 'Value') );
temp(:,:,2) = currentImage(:,:, get( handles.secondChannel, 'Value'));
temp(:,:,3) = currentImage(:,:, get( handles.thirdChannel, 'Value'));
imshow( temp );

% --- Executes during object creation, after setting all properties.
function firstChannel_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in secondChannel.
function secondChannel_Callback(hObject, eventdata, handles)
currentImage = tif2img( [ get( handles.targetDirectory2DImages, 'String' ) filesep ...
    get( handles.imagesPrefix2D, 'String' ) ...
    num2str(handles.currentImageIndex) '.tif'] );

temp(:,:,1) = currentImage(:,:, get( handles.firstChannel, 'Value') );
temp(:,:,2) = currentImage(:,:, get( handles.secondChannel, 'Value'));
temp(:,:,3) = currentImage(:,:, get( handles.thirdChannel, 'Value'));
imshow( temp );

% --- Executes during object creation, after setting all properties.
function secondChannel_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in thirdChannel.
function thirdChannel_Callback(hObject, eventdata, handles)
currentImage = tif2img( [ get( handles.targetDirectory2DImages, 'String' ) filesep ...
    get( handles.imagesPrefix2D, 'String' ) ...
    num2str(handles.currentImageIndex) '.tif'] );

temp(:,:,1) = currentImage(:,:, get( handles.firstChannel, 'Value') );
temp(:,:,2) = currentImage(:,:, get( handles.secondChannel, 'Value'));
temp(:,:,3) = currentImage(:,:, get( handles.thirdChannel, 'Value'));
imshow( temp );

% --- Executes during object creation, after setting all properties.
function thirdChannel_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in previousImageButton.
function previousImageButton_Callback(hObject, eventdata, handles)
%image gallery counter
if handles.currentImageIndex == 0
    return
else
    if handles.currentImageIndex == 1
        handles.currentImageIndex = str2double( ...
            get( handles.numberOfSynthesizedImages2D, 'String' ));
    else
        handles.currentImageIndex = handles.currentImageIndex - 1;
    end
end

%load image into workspace
currentImage = tif2img( [ get( handles.targetDirectory2DImages, 'String' ) filesep ...
    get( handles.imagesPrefix2D, 'String' ) ...
    num2str(handles.currentImageIndex) '.tif'] );

%show image
temp(:,:,1) = currentImage(:,:,1);
temp(:,:,2) = currentImage(:,:,2);
temp(:,:,3) = currentImage(:,:,3);
imshow( temp );

set( handles.currentImageName, ...
    'String', [ get( handles.imagesPrefix2D, 'String' ) ...
    num2str(handles.currentImageIndex) '.tif' ] );

%list of channels
set( handles.firstChannel, ...
    'Value', 1 );
set( handles.secondChannel, ...
    'Value', 2 );
set( handles.thirdChannel, ...
    'Value', 3 );
guidata( hObject, handles );

% --- Executes on button press in nextImageButton.
function nextImageButton_Callback(hObject, eventdata, handles)
%image gallery counter
if handles.currentImageIndex == 0
    return
else
    if handles.currentImageIndex == str2double( ...
            get( handles.numberOfSynthesizedImages2D, 'String' ))
        handles.currentImageIndex = 1;
    else
        handles.currentImageIndex = handles.currentImageIndex + 1;
    end
end

%load image into workspace
currentImage = tif2img( [ get( handles.targetDirectory2DImages, 'String' ) filesep ...
    get( handles.imagesPrefix2D, 'String' ) ...
    num2str(handles.currentImageIndex) '.tif'] );

%show image
temp(:,:,1) = currentImage(:,:,1);
temp(:,:,2) = currentImage(:,:,2);
temp(:,:,3) = currentImage(:,:,3);
imshow( temp );

set( handles.currentImageName, ...
    'String', [ get( handles.imagesPrefix2D, 'String' ) ...
    num2str(handles.currentImageIndex) '.tif' ] );

%list of channels
set( handles.firstChannel, ...
    'Value', 1 );
set( handles.secondChannel, ...
    'Value', 2 );
set( handles.thirdChannel, ...
    'Value', 3 );
guidata( hObject, handles );

%exitButton2D
function exitButton2D_Callback(hObject, eventdata, handles)
if isdeployed
    exit;
else
    close;
end

function synthesizedImagesDirectory_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function selectSynthesizedImagesDirectory_Callback(hObject, eventdata, handles)
%get directory path when pressing the button
directory = uigetdir( pwd, 'Select Directory' );

if isequal( directory, 0 ) || isempty( directory )
    %if the user pressed cancel
    set( handles.synthesizedImagesDirectory, ...
        'String', '' );
else
    %display directory
    set( handles.synthesizedImagesDirectory, ...
        'String', directory );
end

handles.currentImageIndex = 1;
handles.listOfImages = ...
    getImages( get( handles.synthesizedImagesDirectory, 'String' ) );

if isempty( handles.listOfImages )
    wrndlg( 'The selected folder does not contain images' );
else
    
    currentImage = tif2img( handles.listOfImages{1} );
    
    %show image
    temp(:,:,1) = currentImage(:,:,1);
    temp(:,:,2) = currentImage(:,:,2);
    temp(:,:,3) = currentImage(:,:,3);
    imshow( temp );
    
    set( handles.currentImageName, ...
        'String', [ '1 of ' ...
        num2str(length(handles.listOfImages)) ]);
    
    %list of channels
    listOfChannels = {};
    for i=1:1:size( currentImage, 3 )
        listOfChannels{length(listOfChannels)+1} = [ 'channel' num2str(i) ];
    end
    
    set( handles.exploreImagesFirstChannel, ...
        'String', listOfChannels, ...
        'Value', 1 );
    set( handles.exploreImagesSecondChannel, ...
        'Value', 2, ...
        'String', listOfChannels );
    set( handles.exploreImagesThirdChannel, ...
        'Value', 3, ...
        'String', listOfChannels );
end

% Update handles structure
guidata(hObject, handles);

function exploreImagesThirdChannel_Callback(hObject, eventdata, handles)

function exploreImagesThirdChannel_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function exploreImagesSecondChannel_Callback(hObject, eventdata, handles)

function exploreImagesSecondChannel_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function exploreImagesFirstChannel_Callback(hObject, eventdata, handles)

function exploreImagesFirstChannel_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function synthesizer_ResizeFcn(hObject, eventdata, handles)

function listOf2DSlmlInstances_Callback(hObject, eventdata, handles)

function listOf2DSlmlInstances_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in noneButton.
function noneButton_Callback(hObject, eventdata, handles)
% hObject    handle to noneButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of noneButton


% --- Executes on button press in lzwButton.
function lzwButton_Callback(hObject, eventdata, handles)
% hObject    handle to lzwButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of lzwButton


% --- Executes on button press in packbitsButton.
function packbitsButton_Callback(hObject, eventdata, handles)
% hObject    handle to packbitsButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of packbitsButton


% --- Executes on selection change in imageCompressionMenu2D.
function imageCompressionMenu2D_Callback(hObject, eventdata, handles)
% hObject    handle to imageCompressionMenu2D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns imageCompressionMenu2D contents as cell array
%        contents{get(hObject,'Value')} returns selected item from imageCompressionMenu2D


% --- Executes during object creation, after setting all properties.
function imageCompressionMenu2D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imageCompressionMenu2D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on selection change in popupmenu18.
function popupmenu18_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu18 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu18


% --- Executes during object creation, after setting all properties.
function popupmenu18_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu17.
function popupmenu17_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu17 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu17


% --- Executes during object creation, after setting all properties.
function popupmenu17_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu16.
function popupmenu16_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu16 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu16


% --- Executes during object creation, after setting all properties.
function popupmenu16_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu15.
function popupmenu15_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu15 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu15


% --- Executes during object creation, after setting all properties.
function popupmenu15_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in pushbutton24.
function pushbutton24_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton24 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in imageType2D.
function imageType2D_Callback(hObject, eventdata, handles)
% hObject    handle to imageType2D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns imageType2D contents as cell array
%        contents{get(hObject,'Value')} returns selected item from imageType2D

imageType = get( hObject, 'Value' );

switch imageType
    case 1 %'2D'
        set( handles.synthesize2DImagesPanel, ...
            'Visible', 'on' );
        set( handles.synthesize3DImagesPanel, ...
            'Visible', 'off' );
        set( handles.imageType2D, ...
            'Value', 1 );
        set( handles.imageType3D, ...
            'Value', 2 );
        set( handles.log3D, ...
            'Visible', 'off' );
        
        
        set( handles.previousImageButton, ...
            'Visible', 'on' );
        set( handles.nextImageButton, ...
            'Visible', 'on' );
        set( handles.currentImageName, ...
            'Visible', 'on' );
        set( handles.currentImageName, ...
            'Visible', 'on', ...
            'String', '');
        set( handles.gallery, ...
            'Title', '2D Image Synthesizer Gallery' );
        set( handles.currentImage, ...
            'Visible', 'on', ...
            'XTick', [], ...
            'YTick', [], ...
            'ZTick', [] );
    case 2 %'3D'
        set( handles.synthesize2DImagesPanel, ...
            'Visible', 'off' );
        set( handles.synthesize3DImagesPanel, ...
            'Visible', 'on' );
        set( handles.imageType2D, ...
            'Value', 2 );
        set( handles.imageType3D, ...
            'Value', 1 );
        
        set( handles.log3D, ...
            'Visible', 'on' );
        
        
        set( handles.previousImageButton, ...
            'Visible', 'off' );
        set( handles.nextImageButton, ...
            'Visible', 'off' );
        set( handles.currentImageName, ...
            'Visible', 'off' );
        set( handles.currentImage, ...
            'Visible', 'off' );
        set( handles.gallery, ...
            'Title', '3D Image Synthesizer Log' );
        cla;
end

guidata( hObject, handles );

% --- Executes during object creation, after setting all properties.
function imageType2D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imageType2D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in imageType3D.
function imageType3D_Callback(hObject, eventdata, handles)
% hObject    handle to imageType3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns imageType3D contents as cell array
%        contents{get(hObject,'Value')} returns selected item from imageType3D

imageType = get( hObject, 'Value' );

switch imageType
    case 1 %'3D'
        set( handles.synthesize2DImagesPanel, ...
            'Visible', 'off' );
        set( handles.synthesize3DImagesPanel, ...
            'Visible', 'on' );
        set( handles.imageType2D, ...
            'Value', 2 );
        set( handles.imageType3D, ...
            'Value', 1 );
        set( handles.log3D, ...
            'Visible', 'on' );
        
        set( handles.previousImageButton, ...
            'Visible', 'off' );
        set( handles.nextImageButton, ...
            'Visible', 'off' );
        set( handles.currentImage, ...
            'Visible', 'off' );
        cla;
        
        set( handles.currentImageName, ...
            'Visible', 'off' );
        
        set( handles.gallery, ...
            'Title', '3D Image Synthesizer Log' );
    case 2 %'2D'
        set( handles.synthesize2DImagesPanel, ...
            'Visible', 'on' );
        set( handles.synthesize3DImagesPanel, ...
            'Visible', 'off' );
        set( handles.imageType2D, ...
            'Value', 1 );
        set( handles.imageType3D, ...
            'Value', 2 );
        
        set( handles.previousImageButton, ...
            'Visible', 'on' );
        set( handles.nextImageButton, ...
            'Visible', 'on' );
        set( handles.currentImage, ...
            'Visible', 'on', ...
            'XTick', [], ...
            'YTick', [], ...
            'ZTick', [] );
        set( handles.currentImageName, ...
            'Visible', 'on', ...
            'String', '');
        set( handles.log3D, ...
            'Visible', 'off' );
        
        set( handles.gallery, ...
            'Title', '2D Image Synthesizer Gallery' );
end

guidata( hObject, handles );

function imageType3D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function imageCompression3D_Callback(hObject, eventdata, handles)

function imageCompression3D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function popupmenu23_Callback(hObject, eventdata, handles)

function popupmenu23_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function popupmenu22_Callback(hObject, eventdata, handles)

function popupmenu22_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function listbox6_Callback(hObject, eventdata, handles)

function listbox6_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function pushbutton31_Callback(hObject, eventdata, handles)

function pushbutton30_Callback(hObject, eventdata, handles)

function selectTargetDirectory3DButton_Callback(hObject, eventdata, handles)
%on-click
directory = uigetdir( pwd, 'Select Target Directory' );

%in case user press cancel
if isequal(directory,0) || isempty( directory )
    set( handles.targetDirectory2DImages, ...
        'String', '' );
    set( handles.targetDirectory3DImages, ...
        'String', '' );
else
    %display text on screen
    set( handles.targetDirectory2DImages, ...
        'String', directory );
    set( handles.targetDirectory3DImages, ...
        'String', directory );
end

guidata( hObject, handles );




function imagePrefix3D_Callback(hObject, eventdata, handles)
% hObject    handle to imagePrefix3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of imagePrefix3D as text
%        str2double(get(hObject,'String')) returns contents of imagePrefix3D as a double


% --- Executes during object creation, after setting all properties.
function imagePrefix3D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imagePrefix3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function numberOfImages3D_Callback(hObject, eventdata, handles)
% hObject    handle to numberOfImages3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of numberOfImages3D as text
%        str2double(get(hObject,'String')) returns contents of numberOfImages3D as a double


% --- Executes during object creation, after setting all properties.
function numberOfImages3D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to numberOfImages3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function targetDirectory3DImages_Callback(hObject, eventdata, handles)
% hObject    handle to targetDirectory3DImages (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of targetDirectory3DImages as text
%        str2double(get(hObject,'String')) returns contents of targetDirectory3DImages as a double


% --- Executes during object creation, after setting all properties.
function targetDirectory3DImages_CreateFcn(hObject, eventdata, handles)
% hObject    handle to targetDirectory3DImages (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton28.
function pushbutton28_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton28 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function nuclearShapeModel_Callback(hObject, eventdata, handles)
% hObject    handle to nuclearShapeModel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of nuclearShapeModel as text
%        str2double(get(hObject,'String')) returns contents of nuclearShapeModel as a double


% --- Executes during object creation, after setting all properties.
function nuclearShapeModel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nuclearShapeModel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton32.
function pushbutton32_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton32 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function cellShapeModel_Callback(hObject, eventdata, handles)
% hObject    handle to cellShapeModel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of cellShapeModel as text
%        str2double(get(hObject,'String')) returns contents of cellShapeModel as a double


% --- Executes during object creation, after setting all properties.
function cellShapeModel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cellShapeModel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton33.
function pushbutton33_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton33 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function proteinShape_Callback(hObject, eventdata, handles)
% hObject    handle to proteinShape (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of proteinShape as text
%        str2double(get(hObject,'String')) returns contents of proteinShape as a double


% --- Executes during object creation, after setting all properties.
function proteinShape_CreateFcn(hObject, eventdata, handles)
% hObject    handle to proteinShape (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton34.
function pushbutton34_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton34 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in log3D.
function log3D_Callback(hObject, eventdata, handles)
% hObject    handle to log3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns log3D contents as cell array
%        contents{get(hObject,'Value')} returns selected item from log3D


% --- Executes during object creation, after setting all properties.
function log3D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to log3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

set( hObject, ...
    'Position', [3.194 3.993 102.213 39.316] );
guidata( hObject, handles );


% --------------------------------------------------------------------
% function Help_Callback(hObject, eventdata, handles)
%
% function pushbutton35_Callback(hObject, eventdata, handles)

% function edit23_Callback(hObject, eventdata, handles)
%
% function edit23_CreateFcn(hObject, eventdata, handles)
%
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end
%
%
%
% function edit24_Callback(hObject, eventdata, handles)
%
% function edit24_CreateFcn(hObject, eventdata, handles)
%
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end

%
% function edit25_Callback(hObject, eventdata, handles)
%
% function edit25_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to edit25 (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
%
% % Hint: edit controls usually have a white background on Windows.
% %       See ISPC and COMPUTER.
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end
%
% function pushbutton36_Callback(hObject, eventdata, handles)

function listOf3DSlmlInstances_Callback(hObject, eventdata, handles)

function listOf3DSlmlInstances_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listOf3DSlmlInstances (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function addSlmlInstance3D_Callback(hObject, eventdata, handles)

[filename, pathname] = uigetfile( {'*.xml';'*.mat'}, 'Select SLML Instance' );

%in case user press cancel
if isequal( filename, 0 ) || isempty( filename )
    return
else
    %get list of slml instances
    listOfSlmlInstances = get( handles.listOf3DSlmlInstances, ...
        'String' );
    cellFrameworkInstance = get( handles.cellFrameworkInstance3D, ...
        'String' );
    
    %if the list is empty, convert it to cell array and populate with the
    %first instance, this is neccesary because when a listbox is empty
    %matlab considers it an empty string rather than an empty cell array
    if isempty( listOfSlmlInstances ) || ischar( listOfSlmlInstances )
        listOfSlmlInstances = {};
        listOfSlmlInstances{1} = fullfile( pathname, filename );
        cellFrameworkInstance = {};
        cellFrameworkInstance{1} = filename;
    else
        %add the current file to the listboxes
        listOfSlmlInstances{ length(listOfSlmlInstances)+1 } = ...
            fullfile( pathname, filename );
        cellFrameworkInstance{ length(cellFrameworkInstance)+1 } = ...
            filename;
    end
    %display the listboxes on screen
    set( handles.listOf3DSlmlInstances, ...
        'String', listOfSlmlInstances );
    set( handles.cellFrameworkInstance3D, ...
        'String', cellFrameworkInstance );
end
guidata( hObject, handles );

function numberOfSynthesizedImages2D_Callback(hObject, eventdata, handles)

function numberOfSynthesizedImages2D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function numberOfSynthesizedImages3D_Callback(hObject, eventdata, handles)

function imagesPrefix3D_Callback(hObject, eventdata, handles)

function imagesPrefix3D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function exitButton3D_Callback(hObject, eventdata, handles)
if isdeployed
    exit;
else
    close;
end

function cellFrameworkInstance3D_Callback(hObject, eventdata, handles)

function cellFrameworkInstance3D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function cellFrameworkInstance2D_Callback(hObject, eventdata, handles)

function cellFrameworkInstance2D_CreateFcn(hObject, eventdata, handles)

function imageCompressionMenu3D_Callback(hObject, eventdata, handles)

function imageCompressionMenu3D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function numberOfSynthesizedImages3D_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function addSlmlInstance3DButton_Callback(hObject, eventdata, handles)

[filename, pathname] = uigetfile( {'*.xml';'*.mat'}, 'Select SLML Instance' );

%in case user press cancel
if isequal( filename, 0 ) || isempty( filename )
    return
else
    %get list of slml instances
    listOfSlmlInstances = get( handles.listOf3DSlmlInstances, ...
        'String' );
    cellFrameworkInstance = get( handles.cellFrameworkInstance3D, ...
        'String' );
    
    %if the list is empty, convert it to cell array and populate with the
    %first instance, this is neccesary because when a listbox is empty
    %matlab considers it an empty string rather than an empty cell array
    if isempty( listOfSlmlInstances ) || ischar( listOfSlmlInstances )
        listOfSlmlInstances = {};
        listOfSlmlInstances{1} = fullfile( pathname, filename );
        cellFrameworkInstance = {};
        cellFrameworkInstance{1} = filename;
    else
        %add the current file to the listboxes
        listOfSlmlInstances{ length(listOfSlmlInstances)+1 } = ...
            fullfile( pathname, filename );
        cellFrameworkInstance{ length(cellFrameworkInstance)+1 } = ...
            filename;
    end
    %display the listboxes on screen
    set( handles.listOf3DSlmlInstances, ...
        'String', listOfSlmlInstances );
    set( handles.cellFrameworkInstance3D, ...
        'String', cellFrameworkInstance );
end
guidata( hObject, handles );

%synthesizeMultiColorImagesButton
function synthesize2DMultiColorImagesButton_Callback(hObject, eventdata, handles)

%check the contents of every uicontrol before synthesizing images
if isempty( get(handles.listOf2DSlmlInstances, 'String') ) || ...
        ischar( get(handles.listOf2DSlmlInstances ) )
    warndlg( ['Images cannot be synthesized because no '...
        'SLML instances were selected. Add at least one SLML instance to '...
        'the list and try again.'] );
elseif isempty( get(handles.cellFrameworkInstance2D, 'String') ) || ...
        ischar( get(handles.cellFrameworkInstance2D, 'String') )
    warndlg( ['No target directory was selected. ' ...
        'Select a destination and try again.'] );
elseif isempty( get(handles.targetDirectory2DImages) ) || ...
        ~isaDir( get(handles.targetDirectory2DImages, 'String') )
    warndlg( ['The target directory does not exist. '...
        'Select an existing directory and try again.'] );
elseif isempty( get(handles.imagesPrefix2D, 'String') )
    warndlg( ['No images prefix was selected. '...
        'Select a prefix and try again.'] );
elseif isempty( get(handles.numberOfSynthesizedImages2D, 'String') )
    warndlg( ['No number of synthesized images was '...
        'selected. Select a valid number and try again'] );
else
    %get list of slml instances with full path
    listOfSlmlInstances = get( handles.listOf2DSlmlInstances, 'String' );
    
    %get compression
    if get( handles.imageCompressionMenu2D, 'Value' ) == 1
        compression = 'none';
    else
        compression = 'packbits';
    end
    
    %select instance for the framework
    cellFrameworkInstanceIndex = get( handles.cellFrameworkInstance2D, 'Value' );
    temporaryFilename = listOfSlmlInstances{1};
    listOfSlmlInstances{1} = listOfSlmlInstances{ cellFrameworkInstanceIndex };
    listOfSlmlInstances{cellFrameworkInstanceIndex} = temporaryFilename;
    
    %slml models
    models = [];
    h = waitbar(0, 'Parsing SLML instances...');
    for i=1:1:length(listOfSlmlInstances)
        if( isMatFile(listOfSlmlInstances{i}) )
            load(listOfSlmlInstances{i});
            models{i} = model;
        else
            if( isMatFile([ getFileName(listOfSlmlInstances{i})  '.mat']) )
                load([ getFileName(listOfSlmlInstances{i})  '.mat']);
                models{i} = model;
            else
                models{i} = slml2model( listOfSlmlInstances{i} );
            end
        end
        waitbar(i/length(listOfSlmlInstances), h);
    end
    close(h);
    
    %paramaters
    targetDirectory = get( handles.targetDirectory2DImages, 'String' );
    imagesPrefix = get( handles.imagesPrefix2D, 'String' );
    numberOfSynthesizedImages = str2double( get( handles.numberOfSynthesizedImages2D, ...
        'String' ));
    
    %synthesize multicolor images and save them to disk
    h = waitbar(0, 'Synthesizing multicolor images...');
    for i=1:1:numberOfSynthesizedImages
        %icaoberg april 11, 2012
        image = model2img( models );
        img2tif( image, [ targetDirectory filesep imagesPrefix num2str(i) '.tif'], compression );
        waitbar(i/length(numberOfSynthesizedImages), h);
    end
    close(h);
    
    %image gallery counter
    handles.currentImageIndex = 1;
    currentImage = tif2img( [ targetDirectory filesep ...
        imagesPrefix num2str(handles.currentImageIndex) '.tif'] );
    
    %show image
    temp(:,:,1) = currentImage(:,:,1);
    temp(:,:,2) = currentImage(:,:,2);
    temp(:,:,3) = currentImage(:,:,3);
    imshow( temp );
    
    set( handles.currentImageName, ...
        'String', [ imagesPrefix ...
        num2str(handles.currentImageIndex) '.tif' ] );
    
    %list of channels
    listOfChannels = [];
    for i=1:1:length(models)+2
        listOfChannels{length(listOfChannels)+1} = [ 'channel' num2str(i) ];
    end
    set( handles.firstChannel, ...
        'String', listOfChannels, ...
        'Value', 1 );
    set( handles.secondChannel, ...
        'Value', 2, ...
        'String', listOfChannels );
    set( handles.thirdChannel, ...
        'Value', 3, ...
        'String', listOfChannels );
    
    set( handles.text19, ...
        'Visible', 'on' );
    set( handles.firstChannel, ...
        'Visible', 'on' );
    set( handles.secondChannel, ...
        'Visible', 'on' );
    set( handles.thirdChannel, ...
        'Visible', 'on' );
    guidata( hObject, handles );
    
    guidata( hObject, handles );
end


% --------------------------------------------------------------------
function cellOrganizer_Callback(hObject, eventdata, handles)

function psf_Callback(hObject, eventdata, handles)

function sampling_Callback(hObject, eventdata, handles)
if get( handles.sampling, 'Value' ) == 0
    set( handles.text83, 'Visible', 'off' )
    set( handles.numberOfMolecules, 'Visible', 'off' )
else
    set( handles.text83, 'Visible', 'on' )
    set( handles.numberOfMolecules, 'Visible', 'on' )
end

function numberOfMolecules_Callback(hObject, eventdata, handles)

function numberOfMolecules_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
