function [ dnaMask ] = findDnaMask(improt, immask)
%Find the largest hole in cell by subtracting intensity values and then
%uses this hole as a seed for adaptive thresholding
%
%gj july 2012
%gj Oct 9th, 2012  - Uses the distance transform to find nuclear objects


imscale = 0.5;


improtres = imresize(improt, imscale);

if exist('immask', 'var')
    immaskres = logical(imresize(immask, imscale));
    improtres(~immaskres) = 0;
end
[cropimg, range] = pc12_cropImg(improtres);

thresh = ml_rcthreshold(cropimg(cropimg > 0));

imthresh = cropimg > thresh;
for i = 1:size(cropimg,3)
    imthresh(:,:,i) = bwconvhull(imthresh(:,:,i));
end

if exist('immask', 'var')
    imthresh = imthresh .* immaskres;
end
    

pad = zeros(size(imthresh));
pad(2:end-1,2:end-1, 2:end-1) = 1;

imthresh = imthresh .* pad;

dist = bwdist(~imthresh | logical(cropimg > thresh));

 t = ml_rcthreshold(dist(logical(imthresh)));

 [~,i] = max(squeeze(sum(sum(cropimg))));
 
 if i == 1
     i = 2;
 end
 
 dist(:,:,1:i) = 0;
dnaMask =  region_seg(sqrt(dist), dist > t, 2000,3, 0,0);

maskObj = ml_3dfindobj(dnaMask);
maskObj = [maskObj{:}];
[~, ind] = max([maskObj.size]);
maskObj = maskObj(ind);

vox = double([maskObj.voxels]);
ind = sub2ind(size(dnaMask), vox(1,:), vox(2,:), vox(3,:));
dnaMask = zeros(size(dnaMask));
dnaMask(ind) = true;



resmask = zeros(size(improtres));
resmask(range(1):range(2),range(3):range(4),:) = dnaMask;

dnaMask = imresize(resmask, [size(improt,1), size(improt,2)],'nearest', 'Antialiasing', true);
dnaMask(dnaMask > 0) = 1;
dnaMask(dnaMask < 0) = 0;

end

