function [ cropimg, range ] = pc12_cropImg( img, pad)
%PC12_CROPIMG Summary of this function goes here
%   Detailed explanation goes here

if ~exist('padding', 'var')
    pad = 20;
end

imsize = size(img);
mask = img > 0;

%Crop the image so we dont waste extra compute time
sumx = find(sum(sum(mask,3),1));
sumy = find(sum(sum(mask,3),2));

xstart = sumx(1)-pad;
if xstart < 1; xstart = 1; end

xend = sumx(end)+pad;
if xend > imsize(2); xend = imsize(2); end

ystart = sumy(1)-pad;
if ystart < 1; ystart = 1; end

yend = sumy(end)+pad; 
if yend > imsize(1); yend = imsize(1); end


%Crop to remove empty space
cropimg = img(ystart:yend, xstart:xend,:); 

range = [ystart yend xstart xend];

end

