function answer = isaMac()
%ISAMAC True iff the current system is a MacOSX system, false otherwise.
%
% Comment: Similar to ismac but will run in older systems

% Author: Ivan E. Cao-Berg (icaoberg@cmu.edu)
% Created: July 10, 2007
% Last Update: March 2, 2008
%
% Copyright (C) 2008 Center for Bioimage Informatics/Murphy Lab
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

if( nargin ~= 0 )
    error( 'CellOrganizer: Wrong number of input arguments.' );
else
    try
        %this method is supported by Matlab R2007a and on
        answer = ismac;
    catch
        %perform this task if ismac is not supported
        if( isunix && ( strcmpi( computer, 'MAC' ) || ...
                strcmpi( computer, 'MACI' ) ) )
            answer = true;
        else
            answer = false;
        end
    end
end
end%isaMac