function desview(filename)

% tstool/desview
% desview(filename)
%
% graphical viewer for the description of a signal stored in file filename


if nargin < 1, help(mfilename), return, end 

load desview                           

s = signal(filename);

if isempty(s)
	warndlg(['Error opeing signal ' filename]);
end

[path,nam,ext,ver] = fileparts(filename);
lt = list;

lt = append(lt, [num2str(ndim(s)) '-dimensional signal ' filename]);
lt = append(lt, ['Dlens : ' num2str(dlens(s))]);

for n=1:ndim(s)
	a = getaxis(s, n);
	if ~isempty(label(a)) & ~isempty(name(a))
		lt = append(lt, ['X-Axis ' num2str(n)  ' : ' label(a) ' | ' name(a)  ]); 
	end
end

if ~isempty(name(s))
lt = append(lt,['Name : ' name(s)]);
end
lt = append(lt,['Type : ' type(s)]);

if ~isempty(label(yunit(s))) & ~isempty(yname(s))
	lt = append(lt,['Attributes of data values : ']);
	lt = append(lt,[label(yunit(s)) ' | '  yname(s)]);
end

txt = cellstr(lt);

a = figure('Color',[0.8 0.8 0.8], ...
	'Units','normalized', ...
	'Colormap',mat0, ...
	'Visible', 'off', ...
	'Name',['Description for ' nam], ...
	'NumberTitle','off', ...
	'Resize','on', ...
	'Position',[0.46875 0.241211 0.416406 0.375], ...
	'Tag','Fig1');
b = uicontrol('Parent',a, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.00187617 0.622396 0.996248 0.375], ...
	'Style','text', ...
	'String',txt, ...
	'HorizontalAlignment','left', ...
	'Tag','Description');
b = uicontrol('Parent',a, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.00187617 0.322917 0.996248 0.299479], ...
	'String',cellstr(comment(s)), ...
	'Style','listbox', ...
	'Tag','Comment', ...
	'Value',1);
b = uicontrol('Parent',a, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.00187617 0.00520833 0.996248 0.335938], ...
	'String',cellstr(history(s)), ...
	'Style','listbox', ...
	'Tag','History', ...
	'Value',1);


set(a, 'Visible', 'on');
