function TSTOOLunittab=units
% Script to generate a .mat file called
% units.mat which is the database for the unit class
% After appending new units please execute this script in
% directory @unit/private

%
% Label 		factor    M  L  T  C  K  I ML RD 
% -----------------------------------------------
% lbm			0.45359   1
% in			2.54e-2   0  1
% ft			0.3048    0  1
% 
% s 			1.0 	  0  0  1
% h 			3600.0    0  0  1
% min			60.0	  0  0  1
% 
% lb			4.4482    1  1  -2
% lbf			4.4482    1  1  -2
% in/s  		2.54e-2   0  1  -1
% in/s^2		2.54e-2   0  1  -2
% g's			9.80665   0  1  -2
% psi			6894.8    1  -1 -2
% 
% BTU			1055.1    1  2  -2
% W/m^2 		1.0 	  1  0  -3  	 
% BTU/h*ft^2	3.1547    1  0  -3  	 
% 
% hz			6.28319   0  0  -1 0  0  0  0  1
% rpm			0.10472   0  0  -1 0  0  0  0  1
% 
% A 			1.0 	  0  0  0  1
% W 			1.0 	  1  2  -3 
% V 			1.0 	  1  2  -3 -1
% Ohm			1.0 	  1  2  -3 -2
% pC			1.0e-12   0  0  1  1
% -----------------------------------------------
%
% mass, length, time, current, temperature,luminal_intensity,
% mole and plane_angle are eight different dimensions to
% define different units.

% a unit is described by a label (e.g. 'Hz'), a name (e.g. 'Hertz'), the quantity it describes (english and
% german version) (e.g. 'Frequency' and 'Frequenz') and a row vector with 9 entries. The last eigth numbers
% are the exponents of the eigth SI basic units (mass, length, time, current, temperature, luminal, intensity, amount
% of matter and plane angle). For example the unit 'm' (meters) has the exponents 0  1  0  0  0  0  0  0 .
% The first number is the factor  to multiply the product of the SI basic units to get the resulting unit.
% (e.g. km (kilometer) has a factor of 1000 compared to the standard unit m^1).


TSTOOLunittab = { ... 
'lbm'			''			'mass'	'Masse'						[0.45359   	1  0  0  0  0  0  0  0] 20 1 ; ...
'in'			'inch'		'length'    'Laenge'				[2.54e-2   	0  1  0  0  0  0  0  0] 20 1 ; ...
'ft'			'feet'		'length'    'Laenge'				[0.3048    	0  1  0  0  0  0  0  0] 20 1 ; ...
's' 			'second'	'time'      'Zeit'					[1.0 	  	0  0  1  0  0  0  0  0] 20 1 ; ...
'h' 			'hour' 		'time'      'Zeit'					[3600.0    	0  0  1  0  0  0  0  0] 20 1 ; ...
'min'			'minute'	'time'      'Zeit'					[60.0	  	0  0  1  0  0  0  0  0] 20 1 ; ...
'b'				''				''			''					[4.4482    	1  1  -2 0  0  0  0  0] 20 1 ; ...
'bf'  			''				''			''					[4.4482   	1  1  -2 0  0  0  0  0] 20 1 ; ...
'in/s' 			''				''			''					[2.54e-2  	0  1  -1 0  0  0  0  0] 20 1 ; ...
'in/s^2'			''				''			''					[2.54e-2   	0  1  -2 0  0  0  0  0] 20 1 ; ...
'g'  			'earth. grav'	'acceleration'    'Beschleunigung'		[9.80665   	0  1  -2 0  0  0  0  0] 20 1 ; ...
'psi' 			'pounds per square inch'	'pressure'      'Druck'			[6894.8    	1 -1 -2  0  0  0  0  0] 20 1 ; ...
'BTU'  			''				''			''					[1055.1    	1  2  -2 0  0  0  0  0] 20 1 ; ...
'W/m^2'			''				''			''					[1.0	    1  0  -3 0  0  0  0  0] 20 1 ; ...
'BTU/h*ft^2'	''				''			''					[3.1547    	1  0  -3 0  0  0  0  0] 20 1 ; ...
'A'				'Ampere'	'current'      'Strom'				[1.0		0  0  0  1  0  0  0  0] 20 1 ; ...
'W'				'Watt'		'power'		  'Leistung'			[1.0		1  2  -3 0  0  0  0  0] 10 1 ; ...
'PS'				'horse power'		'power'		  'Leistung'			[745.7		1  2  -3 0  0  0  0  0] 20 1 ; ...
'V'				'Volt'		'voltage'	  'Spannung'			[1.0		1  2  -3 -1 0  0  0  0] 20 1 ; ...
'V^2'				'Volt squared'		''	  ''			[1.0		2  4  -6 -2 0  0  0  0] 10 1 ; ...
'mV'			'miliVolt'	'voltage'		'Spannung'			[1e-3		1  2  -3 -1 0  0  0  0] 20 1 ; ...
'Ohm'			'Ohm' 		'resistance'	'Widerstand'				[1.0		1  2  -3 -2 0  0  0  0] 20 1 ; ...
'pC'  			'picoCoulomb' 	'electric charge'	'Ladung'			[1.0e-12	0  0  1  1  0  0  0  0] 20 1 ; ...
'nC'  			'nanoCoulomb' 	'electric charge'	'Ladung'			[1.0e-9		0  0  1  1  0  0  0  0] 20 1 ; ...
'C'  			'Coulomb' 		'electric charge'	'Ladung'			[1.0		0  0  1  1  0  0  0  0] 20 1 ; ...						  
'm'				'meter'			'length'    'Laenge'				[1.0		0  1  0 0 0 0 0 0] 20 1 ; ...
'km'			'kilometer'		'length'    'Laenge'				[1000.0 	0  1  0 0 0 0 0 0] 20 1 ; ...		  
'mm'			'milimeter' 	'length'    'Laenge'				[1.0e-3 	0  1  0 0 0 0 0 0] 20 1 ; ... 			
'nm'			'nanometer' 	'length'    'Laenge'				[1.0e-9 	0  1  0 0 0 0 0 0] 20 1 ; ... 						
'Hz'			'Hertz' 		'frequency'		'Frequenz'		[1.0 		0  0  -1 0 0 0 0 0] 20 1 ; ...					 
'rpm'			'rounds per minute' 	'angular speed'	 'Drehzahl'		[0.10471976 0  0  -1 0 0 0 0 1] 20 1 ; ...						 
'Pa'			'Pascal'		'pressure'      'Druck'				[1.0		1 -1  -2 0 0 0 0 0] 20 20e-6 ; ...						 
'N'				'Newton'		'force'			'Kraft' 		[1.0		1 1 -2 0 0 0 0 0] 20 1 ; ...			 
'kg'			'kilogram'		'mass'	'Masse'					[1.0		1 0 0 0 0 0 0 0] 20 1 ; ...	
'u'				'atomic unit'		'mass'	'Masse'					[1.660E-27		1 0 0 0 0 0 0 0] 20 1 ; ...	
't'				'ton'		'mass'	'Masse'					[1e3		1 0 0 0 0 0 0 0] 20 1 ; ...							 
'gr'			'gram'			'mass'	'Masse'					[1e-3		1 0 0 0 0 0 0 0] 20 1 ; ...
'K' 			'degree Kelvin' 'temperature'	'Temperatur'			[1.0		0 0 0 0 1 0 0 0] 20 1 ; ...						  
'rad'			'radian'			'angle'		'Ebener Winkel'	[1.0		0 0 0 0 0 0 0 1] 20 1 ; ...						  
'cd'			'candela'			'luminal intensity'	'Lichtstaerke'		[1.0		0 0 0 0 0 1 0 0] 20 1 ; ...  
'mol'			'mole'				'amount of matter'	'Stoffmenge'		[1.0		0 0 0 0 0 0 1 0] 20 1 ; ...						  
'm^2'			'square meter'		'area'	'Flaeche'			[1.0		0 2 0 0 0 0 0 0] 20 1 ; ...						  
'm^3'			'cubic meter'		'volume'	'Volumen'		[1.0		0 3 0 0 0 0 0 0] 20 1 ; ...	
'l'				'litre'		'volume'	'Volumen'				[1e-3		0 3 0 0 0 0 0 0] 20 1 ; ...						  
'km/h'			'kilometers per hour'	'speed'		'Geschwindigkeit'	[0.27777778	0 1 -1 0 0 0 0 0] 20 1 ; ...
'm/s'			'meter per second'		'speed'		'Geschwindigkeit'	[1	0 1 -1 0 0 0 0 0] 20 1 ; ...
'm/s^2' 		''	'acceleration'    'Beschleunigung'			[1   	0  1  -2 0  0  0  0  0] 20 1 ; ...
'J' 			'Joule' 				'energy'	'Energie'	[1.0		1 2 -2 0 0 0 0 0] 20 1 ; ...
'cal' 			'calorie' 				'energy'	'Energie'	[4.186		1 2 -2 0 0 0 0 0] 20 1 ; ...
'eV' 			'electon volt' 				'energy'	'Energie'	[1.602E-19		1 2 -2 0 0 0 0 0] 20 1 ; ...
'kwH' 			'kilo Watt hour' 				'energy'	'Energie'	[3600000	1 2 -2 0 0 0 0 0] 20 1 ; ...
'F' 			'Farad'					'capacity'	'Kapazitaet' 	[1.0		-1 -2 4 2 0 0 0 0] 20 1 ; ...
'T' 			'Tesla' 				'magnetic flux density'	'magn. Flussdichte'	[1.0		1 0 -2 -1 0 0 0 0] 20 1 ; ...
'Wb'			'Weber' 				'magnetic flux'	'magn. Fluss'	[1.0		1 2 -2 -1 0 0 0 0] 20 1 ; ...
'N/m'			'Newton per meter'		'surface tension' 'Oberflaechenspannung'	[1.0	1 0 -2 0 0 0 0 0] 20 1;};

% to be continued ...

%save('units.mat', 'TSTOOLunittab');







