function rs = multires(s, scale)

%tstoolbox/@signal/multires
%   Syntax:
%     * rs = multires(s) => scale=3
%     * rs = multires(s, scale)
%
%   Multires perform multiresolution analysis. Y = MULTIRES
%   (X,H,RH,G,RG,SC) obtains the SC successive details and the low
%   frequency approximation of signal in X from a multiresolution scheme.
%   The analysis lowpass filter H, synthesis lowpass filter RH, analysis
%   highpass filter G and synthesis highpass filter RG are used to
%   implement the scheme.
%
%   Results are given in a scale+1 channels. The first scale channels are
%   the details corresponding to the scales 2^1 to 2^textscale the last
%   row contains the approximation at scale 2^textSC. The original signal
%   can be restored by summing all the channels of the resulting signal.
%
% Copyright 1997-2001 DPI Goettingen, License http://www.physik3.gwdg.de/tstool/gpl.txt

error(nargchk(1,2,nargin));

if nargin < 2
    scale  = 3;
end

g = [-3.1892209182862838e-003  3.4907714233439559e-002 -1.6506428297048015e-001  4.3031272109111551e-001 -6.3735632823573951e-001  4.4029025124158083e-001  8.9751094937654277e-002 -3.2706331418126960e-001  2.7918210181969001e-002  2.1119069216229980e-001 -2.7340262038039707e-002 -1.3238830654795097e-001  6.2397230937871169e-003  7.5924235754876904e-002  7.5889746680921537e-003 -3.6888397799723791e-002 -1.0297659640379151e-002  1.3993768830987109e-002  6.9900145921566450e-003 -3.6442796196453752e-003 -3.1280233859117051e-003  4.0789697826759539e-004  9.4102175044909946e-004  1.1424152079591230e-004 -1.7478724531336753e-004 -6.1035966369542223e-005  1.3945668974395207e-005  1.1336608679277482e-005  1.0435713470450424e-006 -7.3636567922041594e-007 -2.3087840910139062e-007 -2.1093396347711647e-008];
h = [-2.1093396347711647e-008  2.3087840910139062e-007 -7.3636567922041594e-007 -1.0435713470450424e-006  1.1336608679277482e-005 -1.3945668974395207e-005 -6.1035966369542223e-005  1.7478724531336753e-004  1.1424152079591230e-004 -9.4102175044909946e-004  4.0789697826759539e-004  3.1280233859117051e-003 -3.6442796196453752e-003 -6.9900145921566450e-003  1.3993768830987109e-002  1.0297659640379151e-002 -3.6888397799723791e-002 -7.5889746680921537e-003  7.5924235754876904e-002 -6.2397230937871169e-003 -1.3238830654795097e-001  2.7340262038039707e-002  2.1119069216229980e-001 -2.7918210181969001e-002 -3.2706331418126960e-001 -8.9751094937654277e-002  4.4029025124158083e-001  6.3735632823573951e-001  4.3031272109111551e-001  1.6506428297048015e-001  3.4907714233439559e-002  3.1892209182862838e-003];
rg = [-2.1093396347711647e-008 -2.3087840910139062e-007 -7.3636567922041594e-007  1.0435713470450424e-006  1.1336608679277482e-005  1.3945668974395207e-005 -6.1035966369542223e-005 -1.7478724531336753e-004  1.1424152079591230e-004  9.4102175044909946e-004  4.0789697826759539e-004 -3.1280233859117051e-003 -3.6442796196453752e-003  6.9900145921566450e-003  1.3993768830987109e-002 -1.0297659640379151e-002 -3.6888397799723791e-002  7.5889746680921537e-003  7.5924235754876904e-002  6.2397230937871169e-003 -1.3238830654795097e-001 -2.7340262038039707e-002  2.1119069216229980e-001  2.7918210181969001e-002 -3.2706331418126960e-001  8.9751094937654277e-002  4.4029025124158083e-001 -6.3735632823573951e-001  4.3031272109111551e-001 -1.6506428297048015e-001  3.4907714233439559e-002 -3.1892209182862838e-003];
rh = [3.1892209182862838e-003  3.4907714233439559e-002  1.6506428297048015e-001  4.3031272109111551e-001  6.3735632823573951e-001  4.4029025124158083e-001 -8.9751094937654277e-002 -3.2706331418126960e-001 -2.7918210181969001e-002  2.1119069216229980e-001  2.7340262038039707e-002 -1.3238830654795097e-001 -6.2397230937871169e-003  7.5924235754876904e-002 -7.5889746680921537e-003 -3.6888397799723791e-002  1.0297659640379151e-002  1.3993768830987109e-002 -6.9900145921566450e-003 -3.6442796196453752e-003  3.1280233859117051e-003  4.0789697826759539e-004 -9.4102175044909946e-004  1.1424152079591230e-004  1.7478724531336753e-004 -6.1035966369542223e-005 -1.3945668974395207e-005  1.1336608679277482e-005 -1.0435713470450424e-006 -7.3636567922041594e-007  2.3087840910139062e-007 -2.1093396347711647e-008];

c = multires(s.core, h,rh,g,rg, scale);
rs = signal(c, s);	% special constructor calling syntax for working routines
a = achse(unit,1,1);
rs = setaxis(rs, 2, a);
rs = setplothint(rs, 'subplotgraph');
rs = addhistory(rs, ['Multiresolution analysis']);
rs = addcommandlines(rs, 's = multires(s', scale);


