function img2tif( img, filename, compression, index )
% IMG2TIF Saves an image to a multichannel tiff. Input argument
% 'compression' can be 'none', 'lzw' or 'packbits'. Parameter index
% is a boolean flag that allows the user to save the image as an 
% indexed tiff.
%
% Examples
% >> img2tif( a, 'a.tiff' );
% >> img2tif( b, 'b.tiff', 'none' );
% >> img2tif( c, 'c.tiff', 'lzw' );

% Author: Ivan E. Cao-Berg (icaoberg@cmu.edu)
% Created: August 5, 2008
%
% March 7, 2012 R.F. Murphy Change stretching from 2% to min-max
% June 5, 2012 M. Mackie Added parameter to deal with indexed images
% August 4, 2012 D. Sullivan Added logical image "contrast stretching"
% August 6, 2012 I. Cao-Berg Fixed statement where logical images were
%                            stretched to the incorrect value
% January 21, 2013 D. Sullivan no stretching seems to be present, added
%                              min-max stretching
%
% Copyright (C) 2008-2012 Murphy Lab
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

%mmackie 6/5/12
if( nargin < 3)
    compression = 'none';
    index = false;    
end

if( nargin < 4)
    index = false;
end

%devins 8/4/12 added logical contrast stretching
if islogical(img)
  %icaoberg 8/6/2012
  %img = img.*256;    
  img = img.*255;    
end

img=uint8(img);
%D. Sullivan 1/21/13 
%no contrast stretching seems to be present, adding min-max stretching
low_high = stretchlim(img(:));
img = img./low_high(2);

%it will save an image as a mat file just to check contents
%save( [ filename(1:end-4) '.mat' ], 'img' );

%mmackie 6/5/2012
if index
    %save first channel
    imwrite( img(:,:,1), gray, filename, 'Resolution', 300, 'Compression', compression);
    %append other channels to the first channel
    if size(img,3) > 1
        for i=2:1:size(img,3)
            imwrite( img(:,:,i), gray, filename, 'Resolution', 300, 'WriteMode', 'append', 'Compression', compression );
        end
    end    

else
    %save first channel
    imwrite( img(:,:,1), filename, 'Resolution', 300, 'Compression', compression );

    %append other channels to the first channel
    if size(img,3) > 1
        for i=2:1:size(img,3)
            imwrite( img(:,:,i), filename, 'Resolution', 300, 'WriteMode', 'append', 'Compression', compression );
        end
    end
end

end%img2tif
