function passed = check_img_dirs( imgdir )
%Routine to determine if any folders are missing and if so, attempt to
%make those folders and approximate the data that belongs in them (i.e. if
%the DNA folder is missing, use the cell or protein folders to find the
%"nuclear hole" and build a mask for the cell
%
% If cell dir does not exist
%   If protein directory exists
%       Use protein to find cell mask
%   Else
%       return false
%
%
% If DNA dir does not exist
%   %Use the cell image and or protein image to find the nucleus
%
%gj aug 29, 2012
%gj october, 2012

err = MException('CellOrganizer:MissingImgDirs', 'Please check if all image directories exist');
   
protdir = [imgdir filesep 'prot' filesep];
dnadir = [imgdir filesep 'dna' filesep];
celldir = [imgdir filesep 'cell' filesep];
maskdir = [imgdir filesep 'crop' filesep];

passed = true;
%if the cell dir doesnt exist
if ~exist(celldir, 'dir')
    %Use the protdir to find the cell shape
    if exist(protdir, 'dir')
        improt = ml_loadimage(protdir, 'tif');
        
        if exist(maskdir, 'dir')
            immask =  logical(ml_loadimage(maskdir, 'tif'));
        else
            immask = logical(ones(size(improt)));
        end
        
        improt(~immask) = 0;
        
        imcell = findCellMask(improt);
        
        ml_saveimage(imcell, celldir, 'tif');
    else
        passed = false;
    end
end

if ~exist(dnadir, 'dir')
    
    imcell = ml_loadimage(celldir, 'tif');
    
    if exist(protdir, 'dir')
        improt = ml_loadimage(protdir, 'tif');
    else
        throw(err);
    end
    
    %If the cell image is binary valued
    if length(unique(imcell)) <= 2  
        imdna = findDnaMask(improt, imcell);
    else
        imdna = findDnaMask(imcell);
    end
        
    ml_saveimage(imdna, dnadir, 'tif')

end

end

